""" brad: general button window

This class instances a window with a user defined number
of buttons.

"""

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from BaseWindowClass import BaseWindowClass
from Blender.Draw import *

class Buttonwin(BaseWindowClass):

        def __init__(self, LocX, LocY, Width, Height, Row, Column, Title, Deco):

                BaseWindowClass.__init__(self,LocX,LocY,Width,Height)

                self.type="ButtonWin"
                self.Row = Row
                self.Column = Column
                self.LeftMargin = 10  #Left Margin
                self.RightMargin = 10 #Right Margin
                self.UpMargin = 30    #Upper Margin
                self.LowMargin = 40   #Lower Margin
                self.distX = 15       #Orizontal distance between buttons
                self.distY = 5        #Vertical distance between buttons
                self.eventList=[]
                self.tooltipList=[]
                self.captionList=[]
                self.decoration = Deco
                self.title=Title
                self.Visibility = 1

                for u in range(self.Row):
                        eventListCol=[]   #List  of event in the row
                        tooltipListCol=[] #List  of tooltip
                        captionListCol=[] #List  of caption
                        for v in range(self.Column):
                                eventListCol.append(0)
                                tooltipListCol.append("Tooltip"+str(u)+str(v))
                                captionListCol.append(str(u)+str(v))
                        self.eventList.append(eventListCol)
                        self.tooltipList.append(tooltipListCol)
                        self.captionList.append(captionListCol)

        def drawIt(self):

                if self.Visibility == 1:
                        self.ButtonHeight = (self.Height-self.LowMargin-self.UpMargin-
                                                        self.distY*(self.Row-1))/self.Row
                        self.ButtonWidth = 	(self.Width-self.LeftMargin-self.RightMargin-
                                                        self.distX*(self.Column-1))/self.Column
                        if self.decoration == 0:
                                self.drawBox()

                        if self.decoration == 1:
                                self.drawBoxS()

                        buttonY=self.LocY-self.LowMargin-self.ButtonHeight

                        for u in range(self.Row):

                                buttonX=self.LocX+self.LeftMargin

                                for v in range(self.Column):
                                        Button( self.captionList[u][v],
                                                self.eventList[u][v],
                                                buttonX,
                                                buttonY,
                                                self.ButtonWidth,
                                                self.ButtonHeight,
                                                self.tooltipList[u][v])
                                        buttonX=buttonX+self.ButtonWidth+self.distX

                                buttonY=buttonY-self.ButtonHeight-self.distY
                        self.drawTitle(self.title)
                        if self.isSelected == 1:
                                self.drawBoxHF()



