#####################################
# Blended Radiance brad_ies.py      #
#####################################

##############################
# (c) Francesco Anselmo 2005 #
##############################

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
import sys
import string

# class IES: begin
class IES:
    # initialise IES class loading the file
    def __init__(self, filename):
        self.filename = filename
        self.comments=[]
        self.tiltline=0
        self.tiltinfo=[]
        self.lampinfo=[]
        #line "10"
        self.numberoflamps=0
        self.lumensperlamp=0.0
        self.candelamultiplier=0.0
        self.numberofverticalangles=0
        self.numberofhorizontalangles=0
        self.photometrictype=0
        self.unitstype=0
        self.width=0.0
        self.length=0.0
        self.height=0.0
        #line "11"
        self.ballastfactor=0.0
        self.futureuse=1.0
        self.inputwatts=0.0
        #line "12" etc ...
        self.tokens=[]
        self.verticalangles=[]
        self.horizontalangles=[]
        self.intensitydata=[]

        iesfile = open(filename, "r")
        ieslines = iesfile.readlines()
        # look for TILT line
        i=0
        for line in ieslines:
           if string.find(line,"TILT")<0:
              self.comments.append(line)
           else:
              self.tiltline = i
              break
           i += 1
        # check if TILT=INCLUDE and read the next lines
        offset=1
        if string.find(ieslines[self.tiltline],"INCLUDE")>0:
           for i in range(5):
              self.tiltinfo.append(ieslines[self.tiltline+i])
              offset=5
        else:
           self.tiltinfo.append(ieslines[self.tiltline])
        # read fixture information
        for i in range(self.tiltline+offset,len(ieslines)):
           self.lampinfo.append(ieslines[i])
        self.numberoflamps=int(self.lampinfo[0].split()[0])
        self.lumensperlamp=float(self.lampinfo[0].split()[1])
        self.candelamultiplier=float(self.lampinfo[0].split()[2])
        self.numberofverticalangles=int(self.lampinfo[0].split()[3])
        self.numberofhorizontalangles=int(self.lampinfo[0].split()[4])
        self.photometrictype=int(self.lampinfo[0].split()[5])
        self.unitstype=int(self.lampinfo[0].split()[6])
        self.width=float(self.lampinfo[0].split()[7])
        self.length=float(self.lampinfo[0].split()[8])
        self.height=float(self.lampinfo[0].split()[9])
        self.ballastfactor=float(self.lampinfo[1].split()[0])
        self.futureuse=float(self.lampinfo[1].split()[1])
        self.inputwatts=float(self.lampinfo[1].split()[2])
        # tokenise angles and intensity data
        i=0
        for line in ieslines:
           if i>(self.tiltline+offset+1):
              for j in range(len(string.split(line))):
                 self.tokens.append(float(string.split(line)[j]))
           i += 1
        i=0
        while i<len(self.tokens):
           if i<self.numberofverticalangles:
              self.verticalangles.append(self.tokens[i])
           if (i>=self.numberofverticalangles) and (i<(self.numberofhorizontalangles+self.numberofverticalangles)):
              self.horizontalangles.append(self.tokens[i])
           if (i>=(self.numberofhorizontalangles+self.numberofverticalangles)):
              for j in range(self.numberofhorizontalangles):
                 sectorintensitydata=[]
                 for k in range(self.numberofverticalangles):
                    sectorintensitydata.append(self.tokens[i]*self.candelamultiplier*self.ballastfactor*self.futureuse)
                    i+=1
                 self.intensitydata.append(sectorintensitydata)
           i+=1



# class IES: end

def testIES(filename):
   iesfile=IES(filename)
   print iesfile.comments
   #print iesfile.tiltinfo
   #print iesfile.lampinfo
   print iesfile.numberoflamps
   print iesfile.lumensperlamp
   print iesfile.candelamultiplier
   print iesfile.inputwatts
   print iesfile.tokens
   print iesfile.numberofverticalangles
   print iesfile.verticalangles
   print iesfile.numberofhorizontalangles
   print iesfile.horizontalangles
   print iesfile.intensitydata

if __name__ == "__main__":
    testIES(sys.argv[1])
