""" set Radiance simulation parameters
"""

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os
import os.path

from Blender.Draw import *

from BaseWindowClass import BaseWindowClass

from brad_i18n import *

class RadParameterswin(BaseWindowClass):

	def __init__(self, LocX, LocY, Width, Heigth, Title, okEvent, escEvent, Deco):

		BaseWindowClass.__init__(self,LocX,LocY,Width,Heigth)

		self.type="RadParametersWin"

		#self.Height = 110
		self.okE=okEvent
		self.escE=escEvent
		self.decoration=Deco
		self.title=Title

                #self.Quality = Create(1)
                #self.Variability = Create(1)
                #self.Detail = Create(1)

                #self.Penumbras = Create(0)
                #self.Indirect = Create(1)
                #self.PictureResolutionX = Create(512)
                #self.PictureResolutionY = Create(512)

                self.PictureName = Create("")
                self.RawFile = Create("")
                self.OctreeName = Create("")

                self.OptionsFile = Create("")
                self.AmbientFile = Create("")
                self.ZFile = Create("")

                self.oconvOptions = Create("")
                self.mkillumOptions = Create("")

                self.renderOptions = Create("")
                self.pfiltOptions = Create("")

                self.Exposure = Create(0.0)
                self.Eyesep = Create(0.0)
                self.ReportTime = Create(1.0)
                self.ReportFile = Create("")

	#-------------------------------------------#
	#    DRAWING THE BUTTONS                    #
	#-------------------------------------------#

	def drawIt(self):

		if self.Visibility==1:
			if self.decoration == 0:
				self.drawBox()
			else:
				self.drawBoxS()

			#quality variability detail menus
                        #rht = 35 #text row vertical position
                        #rhb = 57 #button row vertical position
                        #self.drawText(self.LocX + 10, self.LocY-rht, 0, 0, 0, msg_Quality)
			#self.Quality = Menu(msg_Quality+" %t|"+msg_High+" %x2|"+msg_Medium+" %x1|"+msg_Low+" %x0|", 0, self.LocX + 10, self.LocY-rhb, (self.Width-20)/3-6, 20, self.Quality.val, msg_Quality)
                        #self.drawText(self.LocX + 10 + (self.Width-20)/3-2, self.LocY-rht, 0, 0, 0, msg_Variability)
                        #self.Variability = Menu(msg_Variability+" %t|"+msg_High+" %x2|"+msg_Medium+" %x1|"+msg_Low+" %x0|", 0, self.LocX + 10 + (self.Width-20)/3-2, self.LocY-rhb, (self.Width-20)/3-6, 20, self.Variability.val, msg_Variability)
                        #self.drawText(self.LocX + 10 + 2*((self.Width-20)/3-2), self.LocY-rht, 0, 0, 0, msg_Detail)
                        #self.Detail = Menu(msg_Detail+" %t|"+msg_High+" %x2|"+msg_Medium+" %x1|"+msg_Low+" %x0|", 0, self.LocX + 10 + 2*((self.Width-20)/3-2), self.LocY-rhb, (self.Width-20)/3-6, 20, self.Detail.val, msg_Detail)

                        #penumbra menu + resolution and indirect textbuttons
                        #rht = 69 #+12
                        #rhb = 91 #+22
                        #self.drawText(self.LocX + 10, self.LocY-rht, 0, 0, 0, msg_Penumbras)
                        #self.Penumbras=Toggle("",0,self.LocX + 10, self.LocY-rhb,(self.Width-20)/3-6, 20,self.Penumbras.val,msg_Penumbras)
                        ##self.Penumbras = Menu(msg_Penumbras+" %t|"+msg_Yes+" %x1|"+msg_No+" %x0|", 0, self.LocX + 10, self.LocY-125, (self.Width-20)/3-6, 20, Penumbras, msg_Penumbras)
                        #self.drawText(self.LocX + 10 + (self.Width-20)/3-2, self.LocY-rht, 0, 0, 0, msg_Indirect)
                        #self.Indirect=Number("",0,self.LocX + 10 + (self.Width-20)/3-2, self.LocY-rhb,(self.Width-20)/3-6, 20,self.Indirect.val,0,8,msg_Indirect)
                        #self.drawText(self.LocX + 10 + 2*((self.Width-20)/3-2), self.LocY-rht, 0, 0, 0, msg_Resolution)
                        #self.PictureResolutionX=Number("x:",0,self.LocX + 10 + 2*((self.Width-20)/3-2), self.LocY-rhb,((self.Width-20)/3-6)/2, 20,self.PictureResolutionX.val,1,4096,msg_Resolution)
                        #self.PictureResolutionY=Number("y:",0,self.LocX + 10 + 2*((self.Width-20)/3-2) + ((self.Width-20)/3-6)/2, self.LocY-rhb,((self.Width-20)/3-6)/2, 20,self.PictureResolutionY.val,1,4096,msg_Resolution)

                        #picturename, rawfilename e octreename string buttons
                        rht = 40 #+12
                        rhb = 64 #+22
                        self.drawText(self.LocX + 10, self.LocY-rht, 0, 0, 0, msg_renderOptions)
                        self.renderOptions = String("",0,self.LocX + 10, self.LocY-rhb,(self.Width-20)/2-6, 20,self.renderOptions.val,64,msg_renderOptions)
                        self.drawText(self.LocX + 10 + (self.Width-20)/2-2, self.LocY-rht, 0, 0, 0, msg_pfiltOptions)
                        self.pfiltOptions=String("",0,self.LocX + 10 + (self.Width-20)/2-2, self.LocY-rhb,(self.Width-20)/2-6, 20,self.pfiltOptions.val,64,msg_pfiltOptions)


                        #optionsfile ambientfile and zfile string buttons
                        rht += 44
                        rhb += 44
                        self.drawText(self.LocX + 10, self.LocY-rht, 0, 0, 0, msg_oconvOptions)
                        self.oconvOptions = String("",0,self.LocX + 10, self.LocY-rhb,(self.Width-20)/2-6, 20,self.oconvOptions.val,64,msg_oconvOptions)
                        self.drawText(self.LocX + 10 + (self.Width-20)/2-2, self.LocY-rht, 0, 0, 0, msg_mkillumOptions)
                        self.mkillumOptions=String("",0,self.LocX + 10 + (self.Width-20)/2-2, self.LocY-rhb,(self.Width-20)/2-6, 20,self.mkillumOptions.val,64,msg_mkillumOptions)

                        # oconvoptions mkillumoptions string buttons
                        rht += 44
                        rhb += 44
                        self.drawText(self.LocX + 10, self.LocY-rht, 0, 0, 0, msg_PictureName)
                        self.PictureName = String("",0,self.LocX + 10, self.LocY-rhb,(self.Width-20)/3-6, 20,self.PictureName.val,64,msg_PictureName)
                        self.drawText(self.LocX + 10 + (self.Width-20)/3-2, self.LocY-rht, 0, 0, 0, msg_RawFile)
                        self.RawFile=String("",0,self.LocX + 10 + (self.Width-20)/3-2, self.LocY-rhb,(self.Width-20)/3-6, 20,self.RawFile.val,64,msg_RawFile)
                        self.drawText(self.LocX + 10 + 2*((self.Width-20)/3-2), self.LocY-rht, 0, 0, 0, msg_OctreeName)
                        self.OctreeName=String("",0,self.LocX + 10 + 2*((self.Width-20)/3-2), self.LocY-rhb, (self.Width-20)/3-6, 20,self.OctreeName.val,64,msg_OctreeName)

                        #renderoptions pfiltoptions string buttons
                        rht += 44
                        rhb += 44
                        self.drawText(self.LocX + 10, self.LocY-rht, 0, 0, 0, msg_OptionsFile)
                        self.OptionsFile = String("",0,self.LocX + 10, self.LocY-rhb,(self.Width-20)/3-6, 20,self.OptionsFile.val,64,msg_OptionsFile)
                        self.drawText(self.LocX + 10 + (self.Width-20)/3-2, self.LocY-rht, 0, 0, 0, msg_AmbientFile)
                        self.AmbientFile=String("",0,self.LocX + 10 + (self.Width-20)/3-2, self.LocY-rhb,(self.Width-20)/3-6, 20,self.AmbientFile.val,64,msg_AmbientFile)
                        self.drawText(self.LocX + 10 + 2*((self.Width-20)/3-2), self.LocY-rht, 0, 0, 0, msg_ZFile)
                        self.ZFile=String("",0,self.LocX + 10 + 2*((self.Width-20)/3-2), self.LocY-rhb, (self.Width-20)/3-6, 20,self.ZFile.val,64,msg_ZFile)

                        #exposure eyesep and reporttime buttons
                        rht += 44
                        rhb += 44
                        self.drawText(self.LocX + 10, self.LocY-rht, 0, 0, 0, msg_Exposure)
                        self.Exposure = Number("",0,self.LocX + 10, self.LocY-rhb,(self.Width-20)/3-6, 20,self.Exposure.val,0.0,10000.0,msg_Exposure)
                        self.drawText(self.LocX + 10 + (self.Width-20)/3-2, self.LocY-rht, 0, 0, 0, msg_Eyesep)
                        self.Eyesep = Number("",0,self.LocX + 10 + (self.Width-20)/3-2, self.LocY-rhb,(self.Width-20)/3-6, 20,self.Eyesep.val,0.0,10000.0,msg_Eyesep)
                        self.drawText(self.LocX + 10 + 2*((self.Width-20)/3-2), self.LocY-rht, 0, 0, 0, msg_Report)
                        self.ReportTime=Number(msg_ReportTime,0,self.LocX + 10 + 2*((self.Width-20)/3-2), self.LocY-rhb,((self.Width-20)/3-6)/2, 20,self.ReportTime.val,0.0,60.0,msg_ReportTime)
                        self.ReportFile=String(msg_ReportFile,0,self.LocX + 10 + 2*((self.Width-20)/3-2) + ((self.Width-20)/3-6)/2, self.LocY-rhb,((self.Width-20)/3-6)/2, 20,self.ReportFile.val,64,msg_ReportFile)

                        #ok button
                        Button(msg_Ok,self.okE,self.LocX+10,self.LocY-self.Height+10,self.Width/3-6,20)

			self.drawTitle(self.title)
			if self.isSelected == 1:
				self.drawBoxHF()



