################################
# Blended Radiance brad_obj.py #
################################

##############################
# (c) Francesco Anselmo 2005 #
##############################

#    This file is part of brad (Blended RADiance).
#
#    brad is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    brad is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with Foobar; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import Blender
import math, sys, os
from Blender import NMesh, Object
from math import *

def exportRadianceMeshOBJ(object, basefilename, directory):

    registered_data = Blender.Registry.GetKey('brad')
    if registered_data:
      brad_path  = registered_data['brad_path']
      convert_path  = registered_data['convert_path']
      debug  = registered_data['debug']

    """
    file = open(basefilename, "w")
    std=sys.stdout
    sys.stdout=file
    """

    objname = object.name
    meshname = object.data.name
    mesh = NMesh.GetRaw(meshname)

    objfilename = basefilename+".obj"
    objfile = open(objfilename, "w")

    mtlfilename = basefilename+".mtl"
    mtlfile = open(mtlfilename, "w")

    radmtlfilename = basefilename+".mat"
    radmtlfile = open(radmtlfilename, "w")

    objfile.write("# brad OBJ export module")
    objfile.write("\n# object: " + str(objname))
    objfile.write("\n# total verticis: " + str(len(mesh.verts)))
    objfile.write("\n# total faces: " + str(len(mesh.faces)))

    #objfile.write("maplib " + mtlfilename)
    # useful for syzygy objinput: next line
    #objfile.write("\n\nmtllib " + os.path.join(os.getcwd(),mtlfilename) + "\n")
    # useful for syzygy objinput: previous line

    objfile.write("\n# Verticis\n")
    for vertex in mesh.verts:
        x, y, z = vertex.co
        #nx, ny, nz = vertex.no
        objfile.write("v %f %f %f\n" % (x, y, z))
        #print "vn %f %f %f" % (nx, ny, nz)

    objfile.write("\n# Vertex Normals\n")
    for face in mesh.faces:
       for vertex in face.v:
           objfile.write("vn " + str(vertex.no[0]) + " " + str(vertex.no[1]) + " " + str(vertex.no[2]) + "\n")

    objfile.write("\n# Vertex Textures\n")
    for face in mesh.faces:
       #print face.uv
       for uvco in face.uv:
           objfile.write("vt " + str(uvco[0]) + " " + str(uvco[1]) + "\n")
       #for vertex in face.v:
       #    print "vt", vertex.uvco[0], vertex.uvco[1], vertex.uvco[2]

    if not mesh.materials:             # if there are no materials ...
       newmat = Blender.Material.New()  # create one ...
       mesh.materials.append(newmat)    # and append it to the mesh's list of mats
       mesh.update()

    # useful for syzygy objinput: next 2 lines
    #objfile.write("usemtl " + str(mesh.materials[0].getName()) + "\n\n")
    #mtlfile.write("newmtl " + str(mesh.materials[0].getName()) + "\n")
    # useful for syzygy objinput: previous 2 lines
    r,g,b = mesh.materials[0].getRGBCol()
    mtlfile.write("Kd " + " " +  str(r) + " " +  str(g) + " " +  str(b) + "\n")
    a = mesh.materials[0].getAmb()
    r *= a
    g *= a
    b *= a
    mtlfile.write("Ka " + " " +  str(r) + " " +  str(g) + " " +  str(b) + "\n")
    r,g,b = mesh.materials[0].getSpecCol()
    mtlfile.write("Ks " + " " +  str(r) + " " +  str(g) + " " +  str(b) + "\n\n")

    # useful for syzygy objinput: next line
    objfile.write("g " +  str(object.name) + "\n\n")
    # useful for syzygy objinput: previous line

    faceindex = 0
    for face in mesh.faces:
        #face.v.reverse()    # flips all face normals (is it useful?)
        if mesh.hasFaceUV() and face.mode == mesh.FaceModes.TEX:
            facematerialname = face.image.getFilename()
            facematerialbasename = os.path.splitext(os.path.basename(facematerialname))[0]
            facematerialextension = os.path.splitext(os.path.basename(facematerialname))[1]
            #objfile.write("usemap " os.path.basename(str(face.image.getFilename())))
            # useful for syzygy objinput: next line
            #objfile.write("usemtl " + os.path.basename(str(face.image.getFilename())) + "\n")
            # useful for syzygy objinput: previous line
            mtlfile.write("newmtl " + os.path.basename(str(face.image.getFilename())) + "\n")
            r,g,b = mesh.materials[face.mat].getRGBCol()
            specularity = mesh.materials[face.mat].getSpec()
            roughness = "0"
            radmtlfile.write("void colorpict "+facematerialbasename+"\n")
            radmtlfile.write("7 red green blue "+facematerialbasename+".pic"+" . Lu Lv\n")
            radmtlfile.write("0\n")
            radmtlfile.write("0\n\n")
            # only use plastic material (roughness always 0) at the moment
            # must change it to object modifier, as taken from the library
            # or guessed from blender material
            radmtlfile.write(facematerialbasename+" plastic "+ os.path.basename(facematerialname)+ "\n")
            radmtlfile.write("0\n")
            radmtlfile.write("0\n")
            radmtlfile.write("5" + " " +  str(r) + " " +  str(g) + " " +  str(b)+ " " +str(specularity)+ " " +str(roughness)+"\n\n")
            mtlfile.write("Kd " + " " +  str(r) + " " +  str(g) + " " +  str(b) + "\n")
            a = mesh.materials[face.mat].getAmb()
            r *= a
            g *= a
            b *= a
            mtlfile.write("Ka " + " " +  str(r) + " " +  str(g) + " " +  str(b) + "\n")
            r,g,b = mesh.materials[face.mat].getSpecCol()
            mtlfile.write("Ks " + " " +  str(r) + " " +  str(g) + " " +  str(b) + "\n")
            mtlfile.write("map_Kd " + os.path.basename(facematerialname) + "\n\n")

            if not os.path.exists(os.path.join(directory, facematerialbasename + ".pic")):
               # convert the texture picture first to tiff
               convertcommand=convert_path+" "+facematerialname+ " " + os.path.join(directory, facematerialbasename+".tga")
               if debug:
                  print convertcommand

               os.system(convertcommand)
               # then to Radiance pic format
               rat16command="ra_t16 -r " + os.path.join(directory, facematerialbasename+".tga") + " " + os.path.join(directory, facematerialbasename + ".pic")
               if debug:
                  print rat16command
               os.system(rat16command)
               # and, finally, normalise it
               normpatcommand="normpat "+ os.path.join(directory, facematerialbasename + ".pic")
               if debug:
                  print normpatcommand
               os.system(normpatcommand)

        faces = ""
        for vertex in face.v:
            #faces += str(vertex.index + 1) + "/" + str(vertex.index + 1)+ "/" + str(vertex.index + 1) + " "
            faces += str(vertex.index + 1) + "/" + str(faceindex + 1)+ "/" + str(faceindex + 1) + " "
            faceindex += 1
        objfile.write("f " + faces + "\n")
        objfile.write("usemtl " + str(mesh.materials[0].getName()) + "\n")
    objfile.write("\n")

    radmtlfile.close()
    mtlfile.close()
    objfile.close()


    """
    sys.stdout=std
    file.close()
    """

    #print "Selected object saved to", basefilename

if __name__ == "__main__":
    object = Object.GetSelected()[0]
    filename = object.name
    exportRadianceMeshOBJ(object, filename, "")
