/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/***************************************************************************
 *            callbacks.c
 *
 *  Sat Aug 21 23:24:01 2004
 *  Copyright  2004  Gergely Polonkai
 *  polesz@techinfo.hu
 ***************************************************************************/
/***************************************************************************
 * Widget callbacks
 ***************************************************************************/

#include <gtk/gtk.h>
#include <vte/vte.h>
#include <string.h>
#include <gdk/gdkkeysyms.h>

#include "variables.h"
#include "functions.h"

/*
 * destroy_event()
 * Called when a widget gets the destroy signal.
 */
void
destroy_event(GtkWidget *widget, gpointer data)
{
	if (widget == static_data.main_window)
	{
		gtk_main_quit();
	}
}

/*
 * delete_event()
 * Called when a widget gets the delete signal.
 */
gboolean
delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	exit_cleanly(TRUE);
	/* exit_cleanly() will never return, but return FALSE to prevent warnings during compile */
	return FALSE;
}

/*
 * activate_event()
 * Called when a GtkEntry widget gets the activate signal (e.g enter is pressed).
 */
void
activate_event(GtkWidget *widget, gpointer data)
{
	tab_data_t *tab = data;
	
	/* It is yet usable with the command line */
	if (tab)
	{
		if (widget == tab->commandline)
		{
			gchar *text;

			text = (gchar *)gtk_entry_get_text(GTK_ENTRY(widget));

			/* If text is empty, have to return immediately, because it will generate a segfault */
			if (!*text)
				return;

			process_line(tab, text);

			if ((tab->want_echo) && (*text))
				history_add(text);

			gtk_entry_set_text(GTK_ENTRY(widget), "");
		}
	}
}

/*
 * commandline_keypress()
 * Called whenever a key is pressed when the command line is active
 */
int
commandline_keypress(GtkEntry *text_entry, GdkEventKey *event, gpointer data)
{
	tab_data_t *tab = data;
	
	if (tab)
	{
		if (text_entry == GTK_ENTRY(tab->commandline))
		{
			gchar *next_command;
			switch (event->keyval)
			{
				case GDK_Up:
					next_command = history_get_previous();
					break;
				case GDK_Down:
					next_command = history_get_next();
					break;
			}
			if ((event->keyval == GDK_Up) || (event->keyval == GDK_Down))
			{
				if (next_command != NULL)
				{
					gtk_entry_set_text(GTK_ENTRY(tab->commandline), next_command);
					gtk_editable_set_position(GTK_EDITABLE(tab->commandline), -1);
				}
				return TRUE;
			}
		}
	}
	
	return FALSE;
}

/*
 * vte_clicked()
 * Called when the user clicks on the terminal widget
 */
int
vte_clicked(GtkEntry *vte, gpointer data)
{
	tab_data_t *tab;

	feed_info_to_terminal(tab, TRUE, "Why are you clickin' me?");

	gtk_widget_grab_focus(GTK_WIDGET(tab->commandline));
	
	return TRUE;
}

/*
 * grab_focus()
 * Called when a widget other than the command line gets the focus
 */
void
grab_focus(GtkWidget *widget, gpointer data)
{
	tab_data_t *tab;
	if (tab->commandline != NULL)
		gtk_widget_grab_focus(tab->commandline);
}
