/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/***************************************************************************
 *            functions.h
 *
 *  Sat Aug 21 23:45:09 2004
 *  Copyright  2004  Gergely Polonkai
 *  polesz@techinfo.hu
 ***************************************************************************/
/***************************************************************************
 * Function prototypes
 ***************************************************************************/
#ifndef _BC_FUNCTIONS_H
# define _BC_FUNCTIONS_H

# include "typedefs.h"

# include <gtk/gtk.h>

/* main.c */
void exit_cleanly(gboolean);
gboolean change_mode(tab_data_t *, gboolean, gchar);
gboolean connect_to_host(tab_data_t *, gchar *, short);
void data_ready(gpointer, gint, GdkInputCondition);

/* callbacks.c */
void destroy_event(GtkWidget *, gpointer);
gboolean delete_event(GtkWidget *, GdkEvent *, gpointer);
void activate_event(GtkWidget *, gpointer);
int commandline_keypress(GtkEntry *, GdkEventKey *, gpointer);
int vte_clicked(GtkEntry *, gpointer);
void grab_focus(GtkWidget *, gpointer);

/* widgets.c */
int create_main_window(void);
void feed_message_to_terminal(tab_data_t *, gboolean, gchar *, ...);
void feed_error_to_terminal(tab_data_t *, gboolean, gchar *, ...);
void feed_info_to_terminal(tab_data_t *, gboolean, gchar *, ...);
void set_title(tab_data_t *, gchar *, ...);
void change_terminals_set_scroll_on_output(gboolean activate);
void change_terminals_set_background_transparent(gboolean activate);
void change_terminals_set_font_name(gchar *);
void change_terminals_set_background_saturation(gfloat);

/* config.c */
gboolean config_init(void);
gchar *create_version_string(gboolean);
gboolean set_string_value(gchar *, const gchar *);
gboolean set_boolean_value(gchar *, gboolean);
gboolean set_float_value(gchar *, gfloat);

/* string.c */
signed int wrap_string(gchar *, gchar *, gchar ***);
gboolean str_eq(gchar *, gchar *, gboolean);
signed int valist_to_string(gchar **, gchar *, va_list);
gboolean is_numeric(gchar *);
gboolean trim(gchar *, gchar *, gchar *);
gboolean read_file(gchar *, gchar **);
gboolean write_file(gchar *, const gchar *);
void wl_free(gchar **, gint);
gchar *iconvert(gchar *, gboolean);
gchar *int_to_str(gint);

/* commands.c */
void process_line(tab_data_t *, gchar *);
gchar *history_get_next(void);
gchar *history_get_previous(void);
gboolean history_init(gboolean);
void history_add(gchar *);
void history_free(void);

/* setup.c */
void open_prefs(void);

/* tabs.c */
gboolean add_tab(void);
tab_data_t *get_active_tab(void);
void remove_tab(tab_data_t *);
tab_data_t *get_tab_by_socket_tag(gint);

/* botlist.c */
void open_botlist(void);
void botlist_clear(gboolean);
void botlist_read_from_config(void);
botrecord_t *find_bot(gchar *);

#endif
