/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/***************************************************************************
 *            callbacks.c
 *
 *  Sat Aug 21 23:24:01 2004
 *  Copyright  2004  Gergely Polonkai
 *  polesz@techinfo.hu
 ****************************************************************************/

#include <gtk/gtk.h>
#include <vte/vte.h>
#include <string.h>
#include <gdk/gdkkeysyms.h>

#include "variables.h"
#include "functions.h"

/*
 * destroy_event()
 * Called when a widget gets the destroy signal.
 */
void
destroy_event(GtkWidget *widget, gpointer data)
{
	if (widget == StaticData.main_window)
	{
		gtk_main_quit();
	}
}

/*
 * delete_event()
 * Called when a widget gets the delete signal.
 */
gboolean
delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	ExitCleanly();
	/* ExitCleanly() will never return, but return FALSE to prevent warnings during compile */
	return FALSE;
}

/*
 * activate_event()
 * Called when a GtkEntry widget gets the activate signal (e.g enter is pressed).
 */
void
activate_event(GtkWidget *widget, gpointer data)
{
	if (widget == StaticData.main_commandline)
	{
		gchar *text;
		
		text = (gchar *)gtk_entry_get_text(GTK_ENTRY(widget));
		
		ProcessLine(text);
		
		gtk_entry_set_text(GTK_ENTRY(widget), "");
	}
}

int
commandline_keypress(GtkEntry *text_entry, GdkEventKey *event, gpointer data)
{
	switch (event->keyval)
	{
		case GDK_Up:
			/* TODO: Up arrow was pressed, go up in the command line history */
			return TRUE;
			break;
		case GDK_Down:
			/* TODO: Down arrow was pressed, go back in the command line history */
			return TRUE;
			break;
	}
	
	return FALSE;
}

int
vte_clicked(GtkEntry *vte, gpointer data)
{
	FeedInfoToTerminal(TRUE, "Why are you clickin' me?");

	gtk_widget_grab_focus(GTK_WIDGET(StaticData.main_commandline));
	
	return TRUE;
}

void
grab_focus(GtkWidget *widget, gpointer data)
{
	if (StaticData.main_commandline != NULL)
		gtk_widget_grab_focus(StaticData.main_commandline);
}
