/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/***************************************************************************
 *            botcommander.h
 *
 *  Sun Aug 22 22:30:54 2004
 *  Copyright  2004  Gergely POLONKAI
 *  polesz@techinfo.hu
 ***************************************************************************/
/***************************************************************************
 * This file should be included before any other include files.
 ***************************************************************************/

#ifndef _BC_BOTCOMMANDER_H
# define _BC_BOTCOMMANDER_H

/* Include config.h if we have it */
# ifdef HAVE_CONFIG_H
#  include "config.h"
# endif /* HAVE_CONFIG_H */

/* If the PACKAGE macro is not defined, define it here. It is recommended to
 * append "hardcoded" at the end of the name, so you will see if something went
 * wrong (PACKAGE is defined in config.h)
 */
# ifndef PACKAGE
#  define PACKAGE "hardcoded BotCommander"
# endif /* PACKAGE */
/* If the VERSION macro is not defined, define it here. It is recommended to
 * append "hardcoded" at the end of the name, so you will see if something went
 * wrong (VERSION is defined in config.h)
 */
# ifndef VERSION
#  define VERSION "hardcoded 0.1"
# endif /* VERSION */

/* This is where our configuration is stored in gconf. Must begin and end with a
 * slash (/). */
# define GCONF_CONFIG_ROOT "/apps/botcommander/"

/* Default values of configuration options */
# define DEFAULT_SCROLL_ON_OUTPUT TRUE
# define DEFAULT_TRANSPARENT_BACKGROUND FALSE
# define DEFAULT_BACKGROUND_SATURATION 1.0
# define DEFAULT_TEAROFF_MENUS FALSE
# define DEFAULT_DEBUG_MODE TRUE
# define DEFAULT_VTE_FONT "Monotype 12"
# define DEFAULT_CHANGE_TO_MESSAGE TRUE

/* It is recommended to leave these alone */
/* Allow interpretation of bold ANSI code (default TRUE) */
# define ALLOW_BOLD TRUE
/* Allow beeping when a BEL is arrived (default TRUE) */
# define AUDIBLE_BELL TRUE
/* Allow blinking when a BEL is arrived (default FALSE) */
# define VISIBLE_BELL FALSE

#endif /* _BC_BOTCOMMANDER_H */
