/***************************************************************************
 *   Copyright (C) 2006 by Mark Hokanson <mhoke63@gmail.com>               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/
#ifndef DRINKCOST_H
#define DRINKCOST_H

/**
 * Determines the cost per drink in a container based on it's volume and alcohol percentage.
 *
 * @author Mark Hokanson
 */
class DrinkCost
{
public:
    /**
     * Constructor.
     */
    DrinkCost();
    /**
     * Destructor.
     */
    ~DrinkCost();

	double alcoholPercent() const;
	double cost() const;
	double liquidVolume() const;
    /**
     * Accessor to the initial units.
     * @return the initial units.
     */
    int initialUnits();
    /**
     * Modifier to the initial units.
     * @param intialUnits the units to set.
     */
    void setInitialUnits(int intialUnits);
	void setCost(double cost);
	void setAlcoholPercent(double alcoholPercent);
	void setLiquidVolume(double liquidVolume);
	float pricePerDrink() const;


private:
	static const double CONVERT_LITRE_TO_MILLILITRE;
	static const double CONVERT_OUNCE_TO_MILLILITRE;
	static const double CONVERT_GALLON_TO_MILLILITRE;
	enum InitialUnits { MILILITRES = 1, ONCES = 2, LITRES = 3, GALLONS = 4 };

	/// @param m_initialUnits is the initial units of our drink.
    int m_initialUnits;
    double m_cost;
	double m_alcoholPercent;
	/// @param m_liquidVolume is the total volume of liquid in the containr.
	double m_liquidVolume;

    /**
     *
     */
    double ounceToMillilitre() const;
    /**
     *
     */
    double litreToMillilitre() const;
    /**
     *
     */
    double gallonToMillilitre() const;
};
#endif
