/***************************************************************************
 *   Copyright (C) 2006 by Mark Hokanson <mhoke63@gmail.com>               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/
#include "drinkcost.h"


const double DrinkCost::CONVERT_LITRE_TO_MILLILITRE = 1000.0;
const double DrinkCost::CONVERT_OUNCE_TO_MILLILITRE = 29.57;
const double DrinkCost::CONVERT_GALLON_TO_MILLILITRE = 3785.408;

DrinkCost::DrinkCost()
{
	m_initialUnits = 0;
    m_cost = 0;
	m_alcoholPercent = 0;
	m_liquidVolume = 0;
}

DrinkCost::~DrinkCost()
{}


double DrinkCost::ounceToMillilitre() const
{
	return m_liquidVolume * CONVERT_OUNCE_TO_MILLILITRE;
}

double DrinkCost::litreToMillilitre() const
{
	return m_liquidVolume * CONVERT_LITRE_TO_MILLILITRE;
}

double DrinkCost::gallonToMillilitre() const
{
	return m_liquidVolume * CONVERT_GALLON_TO_MILLILITRE;
}

int DrinkCost::initialUnits()
{
    return m_initialUnits;
}

double DrinkCost::alcoholPercent() const
{
	return m_alcoholPercent;
}

double DrinkCost::cost() const
{
	return m_cost;
}

double DrinkCost::liquidVolume() const
{
	return m_liquidVolume;
}

void DrinkCost::setInitialUnits(int intialUnits)
{
    m_initialUnits = intialUnits;
}

void DrinkCost::setCost(double cost)
{
	m_cost = cost;
}

void DrinkCost::setAlcoholPercent(double alcoholPercent)
{
	m_alcoholPercent = alcoholPercent;
}

void DrinkCost::setLiquidVolume(double liquidVolume)
{
	m_liquidVolume = liquidVolume;
}

float DrinkCost::pricePerDrink() const
{
	float price = 0.0;
	const double ML_OF_ALCOHOL_PER_DRINK = 22.18;
	double alcoholVolume = 0.0; // The amount of alcohol in the container

	if (m_initialUnits == MILILITRES)
	{
		alcoholVolume = (m_alcoholPercent / 100.0) * m_liquidVolume;
		price = m_cost / (alcoholVolume / ML_OF_ALCOHOL_PER_DRINK) ;
	}
	else if (m_initialUnits == ONCES)
	{
		alcoholVolume = (m_alcoholPercent / 100.0) * ounceToMillilitre();
		price = m_cost / (alcoholVolume / ML_OF_ALCOHOL_PER_DRINK) ;
	}
	else if (m_initialUnits == LITRES)
	{
		alcoholVolume = (m_alcoholPercent / 100.0) * litreToMillilitre();
		price = m_cost / (alcoholVolume / ML_OF_ALCOHOL_PER_DRINK) ;
	}
	else if (m_initialUnits == GALLONS)
	{
		alcoholVolume = (m_alcoholPercent / 100.0) * gallonToMillilitre();
		price = m_cost / (alcoholVolume / ML_OF_ALCOHOL_PER_DRINK) ;
	}
	else
		throw "Invalid type of m_initialUnits - way to be a moron!";
	return price;
}
