/***************************************************************************
 *   Copyright (C) 2006 by Mark Hokanson <mhoke63@gmail.com>               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "drinkcost.h"

#include <iostream>
using std::cin;
using std::cout;
using std::cerr;
using std::endl;
#include <iomanip>
using std::fixed;
using std::showpoint;
using std::setprecision;

int bottleUnits();

int main(int argc, char *argv[])
{
    double cost = 0.0;
    double liquidVolume = 0.0;
    double alcoholPercent = 0.0;
    DrinkCost drinkCost;
	char responce = 'y';

    while (responce == 'y')
    {
        cout << "What is the cost of the container? ";
        cin >> cost;
    	drinkCost.setCost(cost);
        cout << "How much liquid is in the container? (no units please) ";
        cin >> liquidVolume;
    	drinkCost.setLiquidVolume(liquidVolume);
    	// Get the container's units.
    	drinkCost.setInitialUnits(bottleUnits());
    	cout << "What is the percent of alcohol in the container? ";
    	cin >> alcoholPercent;
    	drinkCost.setAlcoholPercent(alcoholPercent);
    	cout << fixed << showpoint << setprecision(2) << "The price per drink is: " << drinkCost.pricePerDrink() << endl;
    	cout << "Would you like to calculate another (y/n)? ";
    	cin >> responce;
	}
	if ((responce != 'y') || (responce != 'n'))
	{
		cout << "If you don't know the difference between 'y' and 'n', I give up! " << endl;
		cerr << "Good game.  You must be already drunk. . ." << endl;
	}
}
int bottleUnits()
{
	int result = -1;

    cout << "What units is this in?" << endl;
    cout << "1 = millilitre(s)" << endl;
    cout << "2 = ounce(s)" << endl;
    cout << "3 = litre(s)" << endl;
    cout << "4 = gallon(s)" << endl;
	cout << "Unit selection: ";
	cin >> result;
	if ((result < 1) || (result > 4))
	{
		cerr << "Not an option.  Way to be a moron." << endl;
		bottleUnits();
	}
	return result;
}
