(* Copyright (C) 2014-2015 Daniel Wyckoff *)
(*This file is part of BooleanAlgebrasIntro2.

BooleanAlgebrasIntro2 is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BooleanAlgebrasIntro2 is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with BooleanAlgebrasIntro2.  If not, see <http://www.gnu.org/licenses/>.*)

Require Import FiniteBags.
Require Import TypeUtilities.
Require Import ListUtilities.
Require Import NPeano.
Require Import FunctionProperties.
Require Import ProofIrrelevance.
Require Import NaryFunctions.
Require Import SetUtilities.
Require Import SetUtilities2.


Lemma FiniteT_nat_cardinal_prod : 
  forall {T U:Type}
         (pft:FiniteT T) (pfu:FiniteT U),
         FiniteT_nat_cardinal _ (finite_prod _ _ pft pfu) =
         (FiniteT_nat_cardinal _ pft) * (FiniteT_nat_cardinal _ pfu).
intros T U h1 h2.
apply FiniteT_nat_cardinal_cond.
rewrite full_set_prod.
pose proof (card_fun1_compat (cart_prod (Full_set T) (Full_set U))) as h3.
destruct h3 as [h3l h3r].
assert (h4:Finite (cart_prod (Full_set T) (Full_set U))).
  apply cart_prod_fin.
  rewrite Finite_FiniteT_iff. assumption.
  rewrite Finite_FiniteT_iff. assumption.
specialize (h3l h4).
rewrite card_cart_prod in h3l.
do 2 rewrite FiniteT_nat_cardinal_card_fun1_compat.
assumption.
rewrite Finite_FiniteT_iff. assumption.
rewrite Finite_FiniteT_iff. assumption.
Qed.


Lemma card_nprod_in_l : 
  forall {T:Type} (l:list T), 
    NoDup l ->
    forall n:nat,
    FiniteT_nat_cardinal _ (finite_nprod_in_l l n) = (length l)^n.
intros T l h0 n. revert l h0.
induction n as [|n h1]; simpl; auto.
intros l h0.
pose proof FiniteT_nat_cardinal_unit as h1.
rewrite <- h1. f_equal. apply proof_irrelevance.
intros l h0.
specialize (h1 l). 
pose proof (FiniteT_nat_cardinal_prod 
              (list_to_set_finitet l)
              (finite_nprod_in_l l n)) as h2.
assert (h3:finite_nprod_in_l l (S n) =
            finite_prod {x : T | In x l} ({x : T | In x l} ^ n)
            (list_to_set_finitet l) (finite_nprod_in_l l n)).
  apply proof_irrelevance.
rewrite h3.
rewrite h2.
rewrite card_in_l.
specialize (h1 h0).
rewrite h1. reflexivity. assumption.
Qed.