
(* Copyright (C) 2015 Daniel Wyckoff *)
(*This file is part of BooleanAlgebrasIntro2.

BooleanAlgebrasIntro2 is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BooleanAlgebrasIntro2 is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with BooleanAlgebrasIntro2.  If not, see <http://www.gnu.org/licenses/>.*)

Require Import FiniteMaps2.
Require Import SetUtilities.
Require Import NPeano.
Require Import DecidableDec.
Require Import FiniteMaps.
Require Import DecidableDec.
Require Import TypeUtilities.
Require Import LogicUtilities.
Require Import ProofIrrelevance.

Lemma card_power_set : 
  forall {T:Type} (A:Ensemble T),
    Finite A ->
    card_fun1 (power_set A) = 2 ^ (card_fun1 A).
intros T A h1. 
destruct (eq_dec A (Empty_set _)) as [he | hne].
subst. rewrite power_set_empty.
rewrite card_fun1_sing. rewrite card_fun1_empty. simpl. reflexivity. 
apply not_empty_Inhabited in hne.
destruct hne as [a hina].
pose proof (cardinal_couple true false) as hcc.
assert (h:true <> false). intro h. discriminate. specialize (hcc h). clear h.
pose proof bool_finite as hfb.
rewrite <- Finite_FiniteT_iff in hfb.
pose ([pr:(Ensemble T)*(Fin_map A (Full_set bool) false) | 
       Included (fst pr) A /\  
       forall x:T, Ensembles.In A x -> 
                   (Ensembles.In (fst pr) x ->  (snd pr) |-> x = true) /\
                   (~Ensembles.In (fst pr) x -> (snd pr) |-> x = false)]) as S.
assert (hs:self_fp S). red. constructor.
intros X h2. destruct h2 as [h2]. destruct h2 as [F h2]. 
exists F. red. split. split; auto; try constructor. exists X; auto.
intros F' h3. destruct h3 as [h3l h3r]. destruct h3l as [h3l].
destruct h3l as [X' h3l].
unfold S in h3l. unfold S in h3r. 
inversion h3l as [h3a]. clear h3l. simpl in h3a. destruct h3a as [h3a h3b].
inversion h3r as [h4]. clear h3r. simpl in h4. destruct h4 as [h4l h4r].
inversion h2 as [h2a]. simpl in h2a. destruct h2a as [h2l h2r].
apply fin_map_ext.
intro x.
destruct (classic (Ensembles.In A x)) as [h5 | h6].
specialize (h3b _ h5). specialize (h4r _ h5). specialize (h2r _ h5).
destruct h4r as [h4a h4b]. destruct h2r as [h2a h2b].
destruct (classic (Ensembles.In X x)) as [h6 | h7].
specialize (h2a h6). specialize (h4a h6). congruence.
specialize (h2b h7). specialize (h4b h7). congruence.
rewrite fin_map_app_def. rewrite fin_map_app_def. reflexivity.
assumption. assumption.  
intros pr h2. 
destruct (eq_dec A (fst pr)) as [h3 | h4].
unfold S in h2. destruct h2 as [h2]. destruct h2 as [h2l h2r].
split. constructor. 
pose (fun_to_fin_map A false h1 (fun x=>true)) as F.
assert (hinc:Included (Im A (fun _ : T => true)) (Full_set bool)).
  red. intros; constructor.
pose (fin_map_new_ran F hfb hinc) as F'.
exists F'. constructor. simpl.
split. assumption. intros x h5. split. intro h6.
specialize (h2r _ h5). destruct h2r as [h2a h2b]. specialize (h2a h6). unfold F'. 
pose proof (fin_map_new_ran_compat F hfb hinc x) as hc.
rewrite <- hc. unfold F.
rewrite fun_to_fin_map_compat. reflexivity.
assumption.
intro h6.  
 specialize (h2r _ h5). destruct h2r as [h2a h2b].
rewrite h3 in h5. contradiction. 
constructor. 
exists (fst pr). constructor. simpl. split; auto. 
destruct h2 as [h2]. destruct h2 as [h2l h2r]. 
apply neq_sym in h4.
pose proof (Strict_super_set_contains_new_element _ _ _ h2l h4) as hinh. 
destruct hinh as [x hinh]. destruct hinh as [hinx hnin].  
split.
constructor.
pose (fun_to_fin_map _ false h1 (fun x=>(if (classic_dec (In A x)) then (if (classic_dec (In (fst pr) x)) then true else false) else false))) as F. 
assert (h6: Included (Im A
           (fun x : T =>
            if classic_dec (In A x)
            then if classic_dec (In (fst pr) x) then true else false
            else false)) (Full_set bool)).
  red. intros; constructor.  
pose (fin_map_new_ran F hfb h6) as F'.
exists F'. constructor.
simpl. split; auto. unfold F'. 
intros t h9. rewrite <- fin_map_new_ran_compat. unfold F.
rewrite fun_to_fin_map_compat.
destruct (classic_dec (In A t)) as [h10 | h11].
destruct (classic_dec (In (fst pr) t)) as [h12 | h13]. split. auto.
intro. contradiction. split.
intro h14. contradiction. auto. contradiction. assumption.
constructor.
pose proof (h2r _ hinx) as hinx'. destruct hinx' as [h2a h2b]. pose proof (h2b hnin) as hnin'.
exists (fst pr). constructor. simpl. split; auto.

red in hs.
assert (h2:dom_rel S = power_set A).
  apply Extensionality_Ensembles.
  red. split. red. intros X h2. destruct h2 as [h2]. destruct h2 as [f h2].
  destruct h2 as [h2]. simpl in h2. destruct h2 as [h2l]. constructor.
  assumption.
  red. intros C h2.
  destruct h2 as [h2]. constructor.
pose (fun_to_fin_map _ false h1 (fun x=>(if (classic_dec (In A x)) then (if (classic_dec (In C x)) then true else false) else false))) as F. 
assert (h3:Included (Im A
           (fun x : T =>
            if classic_dec (In A x)
            then if classic_dec (In C x) then true else false
            else false)) (Full_set bool)).
  red; intros; constructor.
pose (fin_map_new_ran F hfb h3) as F'.
exists F'. constructor. simpl.
split. assumption.
intros x h4. unfold F'. rewrite <- fin_map_new_ran_compat.
unfold F. rewrite fun_to_fin_map_compat.
split.
destruct (classic_dec) as [h5 | h6]. intro h6.
destruct (classic_dec) as [h7 | h8]. reflexivity. contradiction.
contradiction.
intro h5.
destruct (classic_dec) as [h6 | h7].
destruct (classic_dec) as [h8 | h9]. contradiction. reflexivity.
contradiction. assumption.
rewrite h2 in hs.
assert (h3:ran_rel S = Full_set (Fin_map A (Full_set bool) false)).
  apply Extensionality_Ensembles.
  red. split. 
  red. intros; constructor. 
  red. intros F ?. constructor.
  exists [x:T | In A x /\ F |-> x = true].
  constructor. simpl. split. red. intros x h3. destruct h3 as [h3].
  destruct h3; auto.
  intros x h3. split. intro h4. destruct h4 as [h4]. destruct h4; auto.
  intro h4. 
  assert (h5:~ (In A x /\ F |-> x = true)).
    intro h5. contradict h4. constructor. assumption.
  apply not_and_or in h5.
  destruct h5 as [h5l | h5r].
  contradiction.
  destruct (F |-> x). contradict h5r. reflexivity. reflexivity.
rewrite h3 in hs.
pose proof (finite_fin_maps A (Full_set bool) false h1 hfb) as h4.
pose proof (power_set_finite _ h1) as h5.
pose (fun_to_fin_map  _ false h1 (fun x=>false)) as D.
assert (h6:Included (Im A (fun _:T=>false)) (Full_set bool)).
  red. intros; constructor.
pose (fin_map_new_ran D hfb h6) as D'.
pose (fin_map_intro _ _ D' h5 h4 _ hs) as F.
assert (h7:card_fun1 (Full_set bool) = 2).
  pose proof (card_fun1_compat (Full_set bool)) as h7.
  destruct h7 as [h7l h7r].
  specialize (h7l hfb).
  rewrite bool_couple in h7l.
  eapply cardinal_is_functional. rewrite bool_couple. apply h7l.
  apply hcc. reflexivity.
rewrite <- h7.
pose proof (card_fin_maps _ _ false h1 hfb) as hcf.
rewrite <- hcf.
rewrite FiniteT_nat_cardinal_card_fun1_compat.
apply bij_dom_ran_card_eq' with F.
red. split.
red.
intros C E h8 h9 h10. 
pose proof (fin_map_app_fin_map_to_fps_compat F (C, F|->C) h8 (eq_refl _)) as h11.
pose proof (fin_map_app_fin_map_to_fps_compat F (E, F|->E) h9 (eq_refl _)) as h12.
rewrite h10 in h11.
unfold F in h11. unfold F in h12.
rewrite <- fin_map_to_fps_compat_s in h11. rewrite <- fin_map_to_fps_compat_s in h12.
inversion h11 as [h11']. simpl in h11'. destruct h11' as [h11a h11b].
inversion h12 as [h12']. simpl in h12'. destruct h12' as [h12a h12b].
apply Extensionality_Ensembles.
red. split.
red. intros x h13.
unfold D' in h11b. 
assert (h15:In A x). auto with sets.
specialize (h11b _ h15). 
destruct h11b as [h11c h11d]. specialize (h11c h13).
rewrite fin_map_app_compat in h12. inversion h12 as [h16]. clear h12. simpl in h16.
destruct h16 as [h17  h18]. specialize (h18 _ h15).
destruct h18 as [h18l h18r].
apply NNPP.
intro h16. 
specialize (h18r h16).
pose proof (fin_map_to_fps_compat_s _ _ D' h5 h4 _ hs) as h19.
pose proof (subsetT_eq_compat _ _ _ _ hs (fp_fin_map_to_fps
              (fin_map_intro (power_set A)
                 (Full_set (Fin_map A (Full_set bool) false)) D' h5 h4 S hs)) h19) as h20.
dependent rewrite <- h20  in h18r.
unfold D' in h18r. rewrite h11c in h18r. discriminate.
red. intros x h13.
unfold D' in h11b. 
assert (h15:In A x). auto with sets.
specialize (h12b _ h15). 
destruct h12b as [h12c h12d]. specialize (h12c h13).
rewrite fin_map_app_compat in h11. inversion h11 as [h16]. clear h12. simpl in h16.
destruct h16 as [h17  h18]. specialize (h18 _ h15).
destruct h18 as [h18l h18r].
apply NNPP.
intro h16. 
specialize (h18r h16).
pose proof (fin_map_to_fps_compat_s _ _ D' h5 h4 _ hs) as h19.
pose proof (subsetT_eq_compat _ _ _ _ hs (fp_fin_map_to_fps
              (fin_map_intro (power_set A)
                 (Full_set (Fin_map A (Full_set bool) false)) D' h5 h4 S hs)) h19) as h20.
dependent rewrite <- h20  in h18r.
rewrite h12c in h18r. discriminate.
red.
intros G ?. 
assert (h8:In (power_set A) [x:T|In A x /\ G |->x = true]).
constructor. red. intros x h8. destruct h8 as [h8]. destruct h8; assumption.
exists [x:T|In A x /\ G |-> x = true]. split; auto.
pose proof (in_fin_map_to_fps F _ h8) as h9. 
unfold F  in h9. 
rewrite <- fin_map_to_fps_compat_s in h9.
inversion h9 as [h10]. clear h9. simpl in h10.
destruct h10 as [h10l h10r].
apply fin_map_ext.
intro x.
destruct (classic_dec (In A x)) as [h11 | h12].
specialize (h10r _ h11).
destruct h10r as [h10a h10b].
destruct (eq_dec (G|->x) true) as [h12|h13].
assert (h13:In [x:T | In A x /\ G |-> x =true] x). constructor.
  split; auto.
specialize (h10a h13). simpl. congruence.
assert (h14:~In [x:T | In A x /\ G |->x = true] x).
  intro h15. destruct h15 as [h15]. destruct h15 as [? h15].
  rewrite h15 in h13. contradict h13. reflexivity.
specialize (h10b h14). simpl. rewrite h10b.
destruct (G |-> x). contradict h13. reflexivity. reflexivity.
rewrite fin_map_app_def. rewrite fin_map_app_def. reflexivity.
assumption. assumption.
Qed.