(* Copyright (C) 2014, Daniel Wyckoff, except for the portions so labeleled
which I got from Daniel Schepler*)

(*This file is part of BooleanAlgebrasIntro2.

BooleanAlgebrasIntro2 is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BooleanAlgebrasIntro2 is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with BooleanAlgebrasIntro2.  If not, see <http://www.gnu.org/licenses/>.*)


(*The portions of this file that are marked "Schepler" were
 copied and pasted from Daniel Schepler's "Zorn's Lemma."  Mine
 are marked "Wyckoff."*)

Require Import Description.
Require Import FunctionalExtensionality.
Require Import Classical.
Require Import FunctionalExtensionality.
Require Import List.
Require Import Ensembles.
Require Import Basics.

(*This is helpful for FiniteMaps functionality.*)
(*Wyckoff*)
Definition f_pr {T U V:Type} (p:T->U->V) : (T*U) -> V :=
  fun pr:T*U => p (fst pr) (snd pr).

(*Wyckoff*)
Definition f_no_pr {T U V:Type} (p:(T*U)->V) : T -> U -> V :=
  fun (x:T) (y:U) => p (x, y).

(*Wyckoff*)
Lemma f_pr_f_no_pr : forall {T U V:Type} (p:(T*U)->V),
                         p = f_pr (f_no_pr p).
intros T U V p. unfold f_pr. unfold f_no_pr.
apply functional_extensionality.
intros pr; simpl. rewrite (surjective_pairing pr).
simpl. reflexivity.
Qed.

(*Wyckoff*)
Lemma f_no_pr_f_pr : forall {T U V:Type} (p:T->U->V),
                         p = (f_no_pr (f_pr p)).
intros T U V p. unfold f_pr. unfold f_no_pr. 
simpl.
apply functional_extensionality. 
intro x. apply functional_extensionality.
intro y. reflexivity.
Qed.

(*Schepler*)
Definition injective {X Y:Type} (f:X->Y) :=
  forall x1 x2:X, f x1 = f x2 -> x1 = x2.
(*Schepler*)
Definition surjective {X Y:Type} (f:X->Y) :=
  forall y:Y, exists x:X, f x = y.
(*Schepler*)
Definition bijective {X Y:Type} (f:X->Y) :=
  injective f /\ surjective f.

(*Schepler*)
Inductive invertible {X Y:Type} (f:X->Y) : Prop :=
  | intro_invertible: forall g:Y->X,
  (forall x:X, g (f x) = x) -> (forall y:Y, f (g y) = y) ->
  invertible f.

(*Schepler*)
Lemma unique_inverse: forall {X Y:Type} (f:X->Y), invertible f ->
  exists! g:Y->X, (forall x:X, g (f x) = x) /\
             (forall y:Y, f (g y) = y).
Proof.
intros.
destruct H.
exists g.
red; split.
tauto.
intros.
destruct H1.
extensionality y.
transitivity (g (f (x' y))).
rewrite H2.
reflexivity.
rewrite H.
reflexivity.
Qed.

(*Schepler*)
Definition function_inverse {X Y:Type} (f:X->Y)
  (i:invertible f) : { g:Y->X | (forall x:X, g (f x) = x) /\
                                (forall y:Y, f (g y) = y) }
  :=
     (constructive_definite_description _
      (unique_inverse f i)).

(*Schepler*)
Lemma bijective_impl_invertible: forall {X Y:Type} (f:X->Y),
  bijective f -> invertible f.
Proof.
intros.
destruct H.
assert (forall y:Y, {x:X | f x = y}).
intro.
apply constructive_definite_description.
pose proof (H0 y).
destruct H1.
exists x.
red; split.
assumption.
intros.
apply H.
transitivity y.
auto with *.
auto with *.
pose (g := fun y:Y => proj1_sig (X0 y)).
pose proof (fun y:Y => proj2_sig (X0 y)).
simpl in H1.
exists g.
intro.
apply H.
unfold g; rewrite H1.
reflexivity.
intro.
unfold g; apply H1.
Qed.

(*Schepler*)
Lemma invertible_impl_bijective: forall {X Y:Type} (f:X->Y),
  invertible f -> bijective f.
Proof.
intros.
destruct H.
split.
red; intros.
congruence.
red; intro.
exists (g y).
apply H0.
Qed.

(* Wyckoff *)
Lemma invertible_impl_inv_invertible: forall {X Y:Type} (f:X->Y)
  (pf:invertible f), invertible (proj1_sig (function_inverse _ pf)).
intros X Y f h1.
destruct (function_inverse f h1) as [g h2].
simpl.
destruct h2 as [h2l h2r].
apply (intro_invertible g f h2r h2l).
Qed.

(* Wyckoff *)
Lemma distinct_functions_differ_at_point: forall {X Y:Type} (f g:X -> Y), 
  f <> g -> (exists x:X, f x <> g x).
intros X Y f g h1.
apply NNPP.
intro h2.
pose proof (not_ex_all_not _ _ h2) as h3.
simpl in h3.
assert (h4:forall x:X, f x = g x).
  intro x.
  specialize (h3 x).
  tauto.
pose proof (functional_extensionality _ _ h4).
contradiction.
Qed.

(*Wyckoff*)
Lemma bij_id : forall T:Type,
                 @bijective T T id.
intro T.
red; split; red; intros; auto.
exists y; auto.
Qed.

(*Wyckoff*)
Lemma bij_compose : 
  forall {T U V:Type} (f:T->U) (g:U->V),
    bijective f -> bijective g ->
    bijective (compose g f).
intros T U V f g h1 h2.
pose proof h1 as h1'. apply bijective_impl_invertible in h1'.
destruct h1 as [h1l h1r].
destruct h2 as [h2l h2r].
red. split.
red.
intros x y h3.
apply h2l in h3.
apply h1l; auto.
red. intros y.
specialize (h2r y).
destruct h2r as [x h2r].
subst.
exists ((proj1_sig (function_inverse _ h1')) x).
unfold compose.
rewrite (match (proj2_sig (function_inverse f h1')) with
           | conj _ pf => pf 
         end).
reflexivity.
Qed.

(*Wyckoff*) 
Lemma inj_compose :   
  forall {T U V:Type} (f:T->U) (g:U->V),
    injective f -> injective g ->
    injective (compose g f).
intros T U V f g h1 h2.
unfold compose. red.
intros x y h3.
apply h2 in h3. apply h1 in h3.
assumption.
Qed.