(* Copyright (C) 2015 Daniel Wyckoff *)
(*This file is part of BooleanAlgebrasIntro2.

BooleanAlgebrasIntro2 is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

BooleanAlgebrasIntro2 is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with BooleanAlgebrasIntro2.  If not, see <http://www.gnu.org/licenses/>.*)

Require Import SetUtilities.
Require Import TypeUtilities.
Require Import LogicUtilities.
Require Import FiniteMaps.
Require Import ArithUtilities.
Require Import ListUtilities.
Require Import FiniteBags.
Require Import NPeano.
Require Import FunctionProperties.
Require Import FunctionalExtensionality.
Require Import Description.
Require Import TypeUtilities2.
Require Import NaryFunctions.
Require Import DecidableDec.


Lemma fin_map_to_l_exp_seg_ex : 
  forall {T U:Type} {A:Ensemble T} {B:Ensemble U} {def:U}
         (F:Fin_map A B def) (la:list T) (lb:list U)
         (pfa:NoDup la), 
    list_to_set la = A -> list_to_set lb = B ->
    exists! f:{m:nat | m < (length la)} -> {y:U|In y lb},
               forall (x:T) (pf:In x la),
                 F |-> x = proj1_sig (f (lind _ pfa _ pf)).
intros T U A B def F la lb h1 h3 h4. 
subst.
assert (h5:forall i:{m:nat | m < length la}, In (F |-> (nth_lt _ h1 _ (proj2_sig i))) lb).
  intro i.
  rewrite list_to_set_in_iff. subst.
  apply fin_map_app_in.
  rewrite <- list_to_set_in_iff.
  pose proof (nth_lt_compat _ h1 _ (proj2_sig i)) as h3.
  destruct h3 as [h3l h3r].
  assumption. 
exists (fun m=> (exist _ (F |-> (nth_lt _ h1 _ (proj2_sig m)))
                       (h5 m))).
red; simpl. split.
intros x h6.
pose proof (lind_compat _ h1 x h6) as h7.
rewrite h7. reflexivity.
intros f h6. apply functional_extensionality.
intro i.
destruct i as [i h7]. simpl.
apply proj1_sig_injective. simpl.
pose proof (nth_lt_compat _ h1 _ h7) as h8.
destruct h8 as [h8l h8r].  
specialize (h6 _ h8l).
rewrite h6. f_equal. f_equal.
pose proof (lind_compat _ h1 _ h8l) as h9.
apply proj1_sig_injective. simpl. simpl in h9.
eapply nth_lt_inj; auto.
apply h9.
Qed.

Definition fin_map_to_l_exp_seg 
           {T U:Type} {A:Ensemble T} {B:Ensemble U} {def:U}
           (F:Fin_map A B def) (la:list T) (lb:list U)
           (pfa:NoDup la) (pflsa:list_to_set la = A)
           (pflsb:list_to_set lb = B) : {m:nat | m < length la}->{y:U|In y lb} :=
  proj1_sig (constructive_definite_description _ (fin_map_to_l_exp_seg_ex F la lb pfa pflsa pflsb)).

Lemma fin_map_to_l_exp_seg_compat : 
  forall {T U:Type} {A:Ensemble T} {B:Ensemble U} {def:U}
         (F:Fin_map A B def) (la:list T) (lb:list U)
         (pfa:NoDup la) (pflsa:list_to_set la = A)
         (pflsb:list_to_set lb = B),
    let f:=(fin_map_to_l_exp_seg F la lb pfa pflsa pflsb) in
    forall (x:T) (pf:In x la),
      F |-> x = proj1_sig (f (lind _ pfa _ pf)).
intros T U A B def F la lb h1 h2 h3 f x h4.
unfold fin_map_to_l_exp_seg in f.
destruct constructive_definite_description as [f' h5]. simpl in f.
apply h5.
Qed.

Lemma fin_map_to_l_exp_bij : 
  forall {T U:Type} (A:Ensemble T) (B:Ensemble U) (def:U)
         (la:list T) (lb:list U)
         (pfa:NoDup la) (pflsa:list_to_set la = A)
         (pflsb:list_to_set lb = B),
    bijective (fun f:Fin_map A B def=> fin_map_to_l_exp_seg f la lb pfa pflsa pflsb).
intros T U A B def la lb h1 h2 h3. subst.
red. split.
red. intros F F' h2.
pose proof (fin_map_to_l_exp_seg_compat F la lb h1 eq_refl eq_refl) as h3.
pose proof (fin_map_to_l_exp_seg_compat F' la lb h1 eq_refl eq_refl) as h4.
apply fin_map_ext.
intro x.
destruct (in_dec eq_dec x la) as [h5 | h6]. 
rewrite (h3 _ h5). rewrite (h4 _ h5).
f_equal. rewrite h2. 
reflexivity. 
rewrite list_to_set_in_iff in h6. 
rewrite fin_map_app_def; auto. rewrite fin_map_app_def; auto.
red.
intro f.
pose [pr:T*U | exists pf:In (fst pr) la, snd pr = (proj1_sig (f (lind _ h1 _ pf)))] as S.
assert (h2:self_fp S).
  red. split. intros x h2.
  destruct h2 as [h2]. destruct h2 as [y h2].
  exists y. red. split. split; auto. constructor. exists x. assumption.
  intros y' h3.
  destruct h3 as [h3l h3r].
  inversion h2 as [h4]. clear h2. simpl in h4. destruct h4 as [h4 h5].
  inversion h3r as [h6]. clear h3r. simpl in h6. destruct h6 as [h6 h7].
  assert (h4 = h6). apply proof_irrelevance. subst.
  reflexivity.
  intros pr h2. destruct h2 as [h2]. destruct h2 as [h2 h3].
  split. constructor. exists (snd pr). constructor. simpl.
  exists h2. assumption.
  constructor. exists (fst pr). constructor. simpl.
  exists h2; auto.
red in h2.
assert (h3:dom_rel S = (list_to_set la)).
  apply Extensionality_Ensembles.
  red. split.
  red. intros x h3. destruct h3 as [h3]. destruct h3 as [y h3].
  inversion h3 as [h4]. clear h3. simpl in h4. destruct h4 as [h4].
  rewrite <- list_to_set_in_iff. assumption.
  red. intros x h3. constructor.
  rewrite <- list_to_set_in_iff in h3.
  exists (proj1_sig (f (lind la h1 x h3))).
  constructor. simpl. exists h3; auto. 
rewrite h3 in h2. 
pose proof (list_to_set_finite la) as h4.
assert (h5:Finite (ran_rel S)).  
  pose proof (fp_ran_rel_im' h2 def) as hran.
  rewrite hran.
  apply finite_image. apply h4.
pose (fin_map_intro _ _ def h4 h5 _ h2) as F.
pose proof (list_to_set_finite lb) as h6.
assert (h7:Included (ran_rel S) (list_to_set lb)).
  red. intros y h8.
  destruct h8 as [h8]. destruct h8 as [x h8]. inversion h8 as [h9]. clear h8.
  simpl in h9. destruct h9 as [h9 ?]. subst.
  pose proof (proj2_sig (f (lind la h1 x h9))) as h10. simpl in h10.
  rewrite <- list_to_set_in_iff.
  assumption.
pose (fin_map_new_ran F h6 h7) as F'.
exists F'.
pose proof (fin_map_to_l_exp_seg_compat F' la lb h1 eq_refl eq_refl) as h8.
apply functional_extensionality.
intro i. destruct i as [i h9].
apply proj1_sig_injective.
specialize (h8 (nth_lt la h1 _ h9)).
pose proof (nth_lt_compat la h1 _ h9) as h10.
destruct h10 as [h10l h10r].
specialize (h8 h10l).
unfold F' in h8.
rewrite <- fin_map_new_ran_compat in h8.
pose proof h10l as h10'.
rewrite list_to_set_in_iff in h10'.
pose proof (in_fin_map_to_fps F _ h10') as h11.
rewrite h8 in h11.
unfold F in h11.
rewrite <- fin_map_to_fps_compat_s in h11.
inversion h11 as [h12]. simpl in h12. unfold F'.
destruct h12 as [h12 h13]. 
unfold F.
pose proof (lind_compat la h1 (nth_lt la h1 i h9) h10l) as h14. 
apply nth_lt_inj in h14.
assert (h15:h10l = h12). apply proof_irrelevance.
assert (h15':lind la h1 (nth_lt la h1 i h9) h12 = exist (fun m=> m < length la) i h9).
  apply proj1_sig_injective. simpl. 
  rewrite <- h15.  assumption.
rewrite h15' in h13. 
rewrite <- h13.
f_equal. f_equal. rewrite h15. rewrite h15'. 
reflexivity.
Qed.

 
Lemma card_l_exp_seg : 
  forall {T:Type} (l:list T) (n:nat), 
    NoDup l ->
    FiniteT_nat_cardinal _ (finite_l_exp_seg l n) = (length l)^n.
intros T l n h1.
pose proof (l_exp_seg_to_nprod_in_l_bij l n) as h2.
apply bijective_impl_invertible in h2.
pose proof (FiniteT_nat_cardinal_bijection).
pose proof (finite_l_exp_seg l n) as h3.
pose proof (FiniteT_nat_cardinal_bijection _ _ h3 _ h2) as h4.
assert (h5:finite_l_exp_seg l n = h3). apply proof_irrelevance. subst.
rewrite <- h4.
pose proof (card_nprod_in_l _ h1 n) as h5.
assert (h6:finite_nprod_in_l l n = bij_finite ({m : nat | m < n} -> {x : T | In x l})
        ({x : T | In x l} ^ n) (l_exp_seg_to_nprod_in_l l n)
        (finite_l_exp_seg l n) h2).  apply proof_irrelevance.
rewrite <- h6.
assumption.
Qed.



Lemma card_fin_maps : 
  forall {T U:Type} (A:Ensemble T) (B:Ensemble U) (def:U)
         (pfa:Finite A) (pfb:Finite B),
    FiniteT_nat_cardinal (Fin_map A B def) (finitet_fin_maps _ _ def pfa pfb) =
    (card_fun1 B)^(card_fun1 A).
intros T U A B def h1 h2.
pose proof (finite_set_list_no_dup _ h1) as h3. destruct h3 as [la h3].
destruct h3 as [h3l h3r].
pose proof (finite_set_list_no_dup _ h2) as h4. destruct h4 as [lb h4].
destruct h4 as [h4l h4r]. subst.
pose proof (fin_map_to_l_exp_bij _ _ def _  lb h3r (eq_refl _) (eq_refl _)) as h5.
apply bijective_impl_invertible in h5.
pose proof (finitet_fin_maps _ _ def h1 h2) as h6.
pose proof (FiniteT_nat_cardinal_bijection _ _ h6 _ h5) as h7.
assert (h6 = (finitet_fin_maps (list_to_set la) (list_to_set lb) def h1 h2)). apply proof_irrelevance.
subst.
rewrite <- h7.
pose proof (card_l_exp_seg _  (length la) h4r) as h8.
assert (h9:finite_l_exp_seg lb (length la) = 
           bij_finite (Fin_map (list_to_set la) (list_to_set lb) def)
   ({m : nat | m < length la} -> {y : U | In y lb})
        (fun f : Fin_map (list_to_set la) (list_to_set lb) def =>
         fin_map_to_l_exp_seg f la lb h3r eq_refl eq_refl)
        (finitet_fin_maps (list_to_set la) (list_to_set lb) def h1 h2) h5).
  apply proof_irrelevance.
rewrite <- h9. clear h9.
rewrite h8.
pose proof (card_fun1_compat (list_to_set lb)) as h9.
pose proof (card_fun1_compat (list_to_set la)) as h10.
destruct h9 as [h9l h9r]. destruct h10 as [h10l h10r].
specialize (h9l h2). specialize (h10l h1).
pose proof (cardinal_length_compat la h3r) as h11.
pose proof (cardinal_length_compat lb h4r) as h12.
assert (h13:length la = card_fun1 (list_to_set la)).
  eapply cardinal_is_functional. apply h11. apply h10l. reflexivity.
assert (h14:length lb = card_fun1 (list_to_set lb)).
  eapply cardinal_is_functional. apply h12. apply h9l. reflexivity.
rewrite h13. rewrite h14.
reflexivity.
Qed. 