// UserCommands.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#ifndef USERCOMMANDS_H
#define USERCOMMANDS_H

#include "String.H"
#include "Person.H"
#include "ServerConnection.H"

#ifdef USESCRIPTS
#include "Interp.H"
#endif

class UserCommands {
public:
  static void Action(ServerConnection *, Person *, String, String);
  static void AddUser(ServerConnection *, Person *, String, String);
  static void AddServer(ServerConnection *, Person *, String, String);
  static void AddShit(ServerConnection *, Person *, String, String);
  static void Alias(ServerConnection *, Person *, String, String);
  static void Ban(ServerConnection *, Person *, String, String);
  static void BanList(ServerConnection *, Person *, String, String);
  static void ChangeLevel(ServerConnection *, Person *, String, String);
  static void Channels(ServerConnection *, Person *, String, String);
  static void Cycle(ServerConnection *, Person *, String, String);
  static void DCCList(ServerConnection *, Person *, String, String);
  static void Deban(ServerConnection *, Person *, String, String);
  static void DelServer(ServerConnection *, Person *, String, String);
  static void DelUser(ServerConnection *, Person *, String, String);
  static void DelShit(ServerConnection *, Person *, String, String);
  static void Deop(ServerConnection *, Person *, String, String);
  static void Die(ServerConnection *, Person *, String, String);
  static void Do(ServerConnection *, Person *, String, String);
#ifdef USESCRIPTS
  static void Execute(ServerConnection *, Person *, String, String);
#endif
  static void Help(ServerConnection *, Person *, String, String);
  static void Ident(ServerConnection *, Person *, String, String);
  static void Invite(ServerConnection *, Person *, String, String);
  static void Join(ServerConnection *, Person *, String, String);
  static void Keep(ServerConnection *, Person *, String, String);
  static void Kick(ServerConnection *, Person *, String, String);
  static void KickBan(ServerConnection *, Person *, String, String);
  static void Load(ServerConnection *, Person *, String, String);
#ifdef USESCRIPTS
  static void LoadScript(ServerConnection *, Person *, String, String);
#endif
  static void Lock(ServerConnection *, Person *, String, String);
  static void Mode(ServerConnection *, Person *, String, String);
  static void Msg(ServerConnection *, Person *, String, String);
  static void Names(ServerConnection *, Person *, String, String);
  static void NextServer(ServerConnection *, Person *, String, String);
  static void Nick(ServerConnection *, Person *, String, String);
  static void NsLookup(ServerConnection *, Person *, String, String);
  static void Op(ServerConnection *, Person *, String, String);
  static void Part(ServerConnection *, Person *, String, String);
  static void Password(ServerConnection *, Person *, String, String);
  static void Reconnect(ServerConnection *, Person *, String, String);
  static void RSpyMessage(ServerConnection *, Person *, String, String);
  static void Save(ServerConnection *, Person *, String, String);
  static void Say(ServerConnection *, Person *, String, String);
  static void Server(ServerConnection *, Person *, String, String);
  static void ServerList(ServerConnection *, Person *, String, String);
  static void SetFloodRate(ServerConnection *, Person *, String, String);
  static void SetVersion(ServerConnection *, Person *, String, String);
  static void ShitList(ServerConnection *, Person *, String, String);
  static void SpyList(ServerConnection *, Person *, String, String);
  static void SpyMessage(ServerConnection *, Person *, String, String);
  static void Stats(ServerConnection *, Person *, String, String);
  static void TBan(ServerConnection *, Person *, String, String);
  static void TKBan(ServerConnection *, Person *, String, String);
  static void Topic(ServerConnection *, Person *, String, String);
  static void Unlock(ServerConnection *, Person *, String, String);
  static void UserList(ServerConnection *, Person *, String, String);
  static void Who(ServerConnection *, Person *, String, String);
  static void Whois(ServerConnection *, Person *, String, String);
};

#endif
