// Message.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#ifndef MESSAGE_H
#define MESSAGE_H

#include "String.H"

struct Message {
  int code;
  String description;

  Message(int c, String d) : code(c), description(d) { }
  int getCode() const { return code; }
  String getMessage() const { return description; }

  bool operator== (Message m) { return getCode () == m.getCode (); }
};

#define Ok (Message(0, ""))
#define NotOnChannel(c) (Message(-1, String("I am not on channel ") + (c)))
#define NotChannelOp(c) (Message(-2, String("I am not channel op on ") + (c)))
#define UserNotFound(w, c) (Message(-3, (w) + " is not on channel " + (c)))
#define UserNotOp(w, c) (Message(-4, (w) + " is not channel op on " + (c)))
#define UserProtected(w, c) (Message(-5, (w) + " is protected on " + (c)))
#define InvalidNick(n) (Message(-6, (n) + " is not a valid nickname"))
#define InvalidChannel(c) (Message(-7, (c) + " is not a valid channel name"))
#define MassOpNotAllowed (Message(-8, "Mass op is not allowed."))
#define UserOnShitList(w) (Message(-9, String("User ") + w + " is on my shitlist"))
#define CanNotChangeTopic(c) (Message(-10, String("I can not change topic on ") + (c)))
#define TopicLocked(c) (Message(-11, String("Topic is locked on ") + (c)))
#define InvalidPort(p) (Message(-12, String((long)(p)) + " is an invalid port number"))
#define InvalidTime(t) (Message(-13, String((long)(t)) + " is an invalid time"))
#define CanNotChangeServer (Message(-14, "I cannot change server without loosing op on one of my channels"))
#define EmptyServerList (Message(-15, "Server list is empty"))
#define InvalidServerNumber(n) (Message(-16, String((long)(n)) + " is an invalid server number"))
#define InvalidParameters (Message(-17, "Invalid parameters"))
#define NotFound(w) (Message(-18, String("I can not find ") + (w)));
#define NotInUserlist(w) (Message(-19, (w) + " is not in my userlist"))
#define NotInShitlist(w) (Message(-20, (w) + " is not in my shitlist"))
#define AlreadyInUserlist(m, mc) (Message(-21, (m) + " is already in userlist on channel(s) " + (mc)))
#define AlreadyInShitlist(m, mc) (Message(-22, (m) + " is already in shitlist on channel(s) " + (mc)))
#define EmptyMessage (Message(-23, "Can not send an empty message"))
#define EmptyAddressee (Message(-24, "Can not send to nobody"))
#define NotToChannel (Message(-25, "Can not send to a channel."))
#define NotConnected (Message(-26, "Not connected."))

#endif
