// DCCParser.C  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD
// Copyright (C) 2002,2005 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "DCCParser.H"
#include "DCCPerson.H"
#include "Parser.H"
#include "BotInterp.H"
#include "Utils.H"

void
DCCParser::parseLine(DCCConnection *cnx, String line)
{
  Person * from = new DCCPerson(cnx);
#ifdef USESCRIPTS
  // Call hooks/dcc/chat-message hook functions
  cnx->get_bot()->botInterp->RunHooks (Hook::DCC_CHAT_MESSAGE, 
				 from->getAddress () + " " + line,
				 scm_list_n (Utils::str2scm (from->getAddress ()),
					     Utils::str2scm (line),
					     SCM_UNDEFINED));
#endif
  Parser::parseMessage(cnx->get_bot()->serverConnection, 
		       from, cnx->get_bot()->nickName,
                       line);
  delete from;
}
