// String.C  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (C) 2002,2005 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#include "String.H"
#include "Utils.H"

#include <cstring>
#include <cctype>
#include <sstream>
#include <iostream>

String::String()
{
}

String::String(const char *s)
{
  my_string = s;
}

String::String(const std::string & s)
{
  my_string = s;
}

String::String(const String & s)
{
  my_string = s.my_string;
}

String::String(long i)
{
  std::ostringstream temp;
  temp << i;
  my_string = temp.str ();
}

String::String(char c)
{
  my_string = std::string (1, c);
}

String::~String()
{
  
}

String &
String::operator=(const char *s)
{
  my_string = s;

  return *this;
}

String &
String::operator=(const String & s)
{
  my_string = s.my_string;

  return *this;
}

String &
String::operator=(const std::string & s)
{
  my_string = s;
  
  return *this;
}

int
String::length() const
{
  return my_string.length ();
}

int
String::find(char c)
{
  return my_string.find (c);
}

void
String::fill (char c)
{
  my_string.replace (0, 
		     my_string.length () - 1, 
		     my_string.length (),
		     c);
}

String
String::pad (int n)
{
  std::string temp = my_string;

  temp.resize (n, ' ');

  return temp;
}

String
String::subString (int start, int end)
{
  if (end < start) return "";

  return my_string.substr (start, (end - start) + 1);
}

String
String::substr (int s, int e)
{
  return subString (s, e);
}

String
String::subString (int start)
{
  return subString (start, my_string.length () - 1);
}

String
String::substr (int s)
{
  return subString (s);
}

String
String::toLower()
{
  return Utils::to_lower (my_string);
}

String
String::toUpper()
{
  return Utils::to_upper (my_string);
}

String
String::trim()
{
  return Utils::trim_str (my_string);
}

int
String::indexOf (char c)
{
  std::string::size_type pos = my_string.find (c);

  if (pos == std::string::npos)
    return -1;
  else
    return pos;
}

char &
String::operator[] (int i)
{
  if (i < 0 || my_string.length () < i) {
    std::cerr << "String index out of range\n";
    std::exit(1);
  }
  return my_string[i];
}

const char &
String::operator[](int i) const
{
  if (i < 0 || my_string.length () < i) {
    std::cerr << "String index out of range\n";
    exit(1);
  }
  return my_string[i];
}

bool
String::operator==(const char *s) const
{
  return my_string == s;
}

bool
String::operator==(const String & s) const
{
  return my_string == s.my_string;
}

bool
String::operator==(const std::string & s) const
{
  return my_string == s;
}

bool
String::operator!=(const char *s) const
{
  return my_string != s;
}

bool
String::operator!=(const String & s) const
{
  return my_string != s.my_string;
}

bool
String::operator!=(const std::string & s) const
{
  return my_string != s;
}

bool
String::operator<(const String & s) const
{
  return my_string < s.my_string;
}

bool
String::operator<(const std::string & s) const
{
  return my_string < s;
}

bool
String::operator>(const String & s) const
{
  return my_string > s.my_string;
}

bool
String::operator<=(const String & s) const
{
  return my_string <= s.my_string;
}

bool
String::operator<=(const std::string & s) const
{
  return my_string <= s;
}

bool
String::operator>=(const String & s) const
{
  return my_string >= s.my_string;
}

bool String::operator>=(const std::string & s) const
{
  return my_string >= s;
}

String
String::operator+(const char *s)
{
  return my_string + s;
}

String
String::operator+(const String & s)
{
  return my_string + s.my_string;
}

String
String::operator+(const std::string & s)
{
  return my_string + s;
}

String::operator const char *() const
{
  return my_string.c_str ();
}

String::operator std::string () const
{
  return my_string;
}

std::ostream &
operator<<(std::ostream & s, const String & st)
{
  return s << st.my_string;
}

std::istream &
operator>>(std::istream & s, String & st)
{
  // The original version of string grabbed an entire line with
  // operator>> so this version has to too (otherwise I'd just replace
  // String with std::string everywhere because it would be just as
  // painful)

  std::string temp;

  std::getline (s, temp);

  st.my_string = temp;

  return s;
}

std::string operator+(const std::string & s, const String & p)
{
  return s + p.my_string;
}

bool operator==(const std::string & s, const String & p)
{
  return p == s;
}

bool operator!=(const std::string & s, const String & p)
{
  return p != s;
}

bool operator>(const std::string & s, const String & p)
{
  return p <= s;
}

bool operator<(const std::string & s, const String & p)
{
  return p >= s;
}

bool operator<=(const std::string & s, const String & p)
{
  return p > s;
}

bool operator>=(const std::string & s, const String & p)
{
  return p < s;
}
