// Parser.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (c) 2002,2003 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#ifndef PARSER_H
#define PARSER_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "String.H"
#include "Person.H"
#include "ServerConnection.H"

#ifdef USESCRIPTS
#include "Interp.H"
#include <libguile.h>
#endif

#include <map>
#include <string>

typedef void (*fptr)(ServerConnection *, Person *, String);

// fptr is a parser function which may either be Scheme or C. fptr
// used to be what funptr is now, but I decided to make the bot even
// more extensible and it is now a function-like object that can be
// used just like it was a function pointer.

// This will take a lot of work to make it actually work...lots of
// SMOBs have to be written :(

// class fptr
// {
// private:
//   typedef void (*funptr)(ServerConnection *, Person *, String);
//   union
//   {
//     funptr Cfunc;
// #ifdef USESCRIPTS
//     SCM Sfunc;
// #endif
//   };
//   bool C;

// public:
//   ftpr () { Cfunc = 0; Sfunc = 0; C = true; };
//   operator= (funptr f) { Cfunc = f; C = true; };
//   operator= (SCM f) { Sfunc = f; C = false; };

//   operator ()(ServerConnection * s, Person * p, String str)
//   {
//     if (C)
//       Cfunc (s, p, str);
//     else {} 
//       // ... SCM not supported for now
//   }
// };

class userFunction {
public:
  void (*function)(ServerConnection *, Person *, String, String);
  int minLevel;
  bool needsChannelName;
#ifdef USESCRIPTS
  int argsCount;
  SCM scmFunc;
#endif

  userFunction(void (*f)(ServerConnection *, Person *,
                         String, String) = 0,
               int m = 0 , bool n = false
#ifdef USESCRIPTS
               , int a = -1, SCM scm_f = 0
#endif
               )
    : function(f), minLevel(m), needsChannelName(n)
#ifdef USESCRIPTS
      ,argsCount(a), scmFunc(scm_f)
#endif
    {
#ifdef USESCRIPTS
      if (scmFunc)
	scm_gc_protect_object(scmFunc);
#endif
    }

#ifdef USESCRIPTS
  ~userFunction()
  { 
    if (scmFunc)
      scm_gc_unprotect_object(scmFunc); 
  }
#endif
};

class Parser {
public:
  static void init ();
  static void parseLine(ServerConnection *, String);

  static void parse001(ServerConnection *, Person *, String);
  static void parse302(ServerConnection *, Person *, String);
  static void parse311(ServerConnection *, Person *, String);
  static void parse315(ServerConnection *, Person *, String);
  static void parse324(ServerConnection *, Person *, String);
  static void parse332(ServerConnection *, Person *, String);
  static void parse352(ServerConnection *, Person *, String);
  static void parse353(ServerConnection *, Person *, String);
  static void parse366(ServerConnection *, Person *, String);
  static void parse367(ServerConnection *, Person *, String);
  static void parse401(ServerConnection *, Person *, String);
  static void parse433(ServerConnection *, Person *, String);
  static void parse473(ServerConnection *, Person *, String);
  static void parseError(ServerConnection *, Person *, String);
  static void parseInvite(ServerConnection *, Person *, String);
  static void parseJoin(ServerConnection *, Person *, String);
  static void parseKick(ServerConnection *, Person *, String);
  static void parseMode(ServerConnection *, Person *, String);
  static void parseNick(ServerConnection *, Person *, String);
  static void parseNotice(ServerConnection *, Person *, String); 
  static void parsePart(ServerConnection *, Person *, String);
  static void parsePing(ServerConnection *, Person *, String);
  static void parsePong(ServerConnection *, Person *, String);
  static void parsePrivmsg(ServerConnection *, Person *, String);
  static void parseQuit(ServerConnection *, Person *, String);
  static void parseTopic(ServerConnection *, Person *, String);

  static void parseCTCP(ServerConnection *, Person *, String,
                        String);
  static void parseMessage(ServerConnection *, Person *, String,
                           String);
#ifdef USESCRIPTS
  static void parseScriptFunction(ServerConnection *, String, bool,
                                  SCM, int, String);
#endif

  static void sendNotice(Person *, String);
private:
  
  static std::map<std::string, fptr, std::less<std::string> > functions;
  
};

#endif
