// BotConfig.H  -*- C++ -*-
// Copyright (C) 2004,2005 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

/*
  Config Database:
  map<key,pair<list<string>,list<watcher>>
  void watcher (key, options, appended?)

  NOTE: The key is always UPPERCASE internally. Keys are converted
  automagically to uppercase by the anything that 

*/

#include <map>
#include <list>
#include <string>

class BotConfig
{
public:
  typedef std::string t_value;
  typedef std::list<t_value> t_value_list;

  typedef void (*t_watcher) (std::string key, t_value_list vals, bool appended);

  typedef std::list<t_watcher> t_watcher_list;
  typedef std::pair<t_value_list, t_watcher_list> t_option_values;

  typedef std::map<std::string, t_option_values> t_options_db;

  
private:
  t_options_db options_db;
  std::string config_filename;

public:
  BotConfig (std::string); // sets config_filename but DOES NOT read config!

  bool read_config (); // true if read successfully. This also clears the option_db.
  bool write_config (); // true if written succesfully

  // Getters
  t_option_values  get_option_values (std::string key);

  

  // Setters
  void set_option_value (std::string key, t_value_list values, 
			 bool append);
  // Convinience proc
  void set_option_value (std::string key, t_value value, bool append);

  std::string set_config_file (std::string new_filename); // returns
							  // old
							  // filename

  bool add_watcher (std::string key, t_watcher new_watcher); // t if key
							   // exists,
							   // f
							   // otherwise
  bool clear_watchers (std::string key); // t if key exists, f
                                        // otherwise

  // Static Procedures (these are for convinience)
  t_value_list get_option_value_list (t_option_values v)
  { return v.first; }

  t_watcher_list get_option_watcher_list (t_option_values v)
  { return v.second; }
};
