// Utils.H  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (c) 2002 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#ifndef UTILS_H
#define UTILS_H

#ifndef HAVE_CONFIG_H
#include "config.h"
#endif

#include <ctime>
#include "String.H"
#include "Bot.H"

#ifdef USESCRIPTS
#include <libguile.h>
#endif

class Utils {
public:
  static String getNick(String);
  static String getUserhost(String);
  static String getKey();
  static String makeWildcard(String);

  static bool isChannel(String);
  static bool isWildcard(String);
  static bool isValidChannelName(String);
  static bool isValidNickName(String);
  static bool isIP(String);

  static int getLevel(Bot *, String);
  static int getLevel(Bot *, String, String);

  static String levelToStr(int);
  static String protToStr(int);
  static String boolToStr(bool);

  static std::time_t strToTime(String);

#ifdef USESCRIPTS
  static String scm2String(SCM);
  static SCM string2SCM(String);
#endif
};

#endif
