// TodoList.H  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD
// Copyright (c) 2002 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#ifndef TODOLIST_H
#define TODOLIST_H

#include <set>
#include <ctime>
#include <functional>

#include "String.H"

class TodoList;

class TodoListItem {
  String line;
  std::time_t when;
public:
  TodoListItem(String l, std::time_t w)
    : line(l), when(w) { }

  bool operator<(const TodoListItem &t) const
    { return when < t.when; }

  friend class TodoList;
};

class TodoList {

  std::multiset<TodoListItem, std::less<TodoListItem> > todoQueue;

public:
  TodoList();
  ~TodoList();

  void addDeban(String, String, std::time_t);

  String getNext();
};

#endif
