// Main.C  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (C) 2002 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <unistd.h>
#include <iostream>
#include <cstdio>
#include <csignal>

#ifdef USESCRIPTS
#include "Interp.H"
#endif

#include "Bot.H"

Bot *b;

void sig_hup(int) {
  if (b) {
    b->userList->read();
    b->userList->addUserFirst("bidon", "bidon", 0, 0, false, 0, "");
    b->reconnect();
  }
}

void printUsage(char *name)
{
  std::cout << "Usage: " << name << " [-h] [-b] [-f file] [-d dir] [-D]\n"
    " -h        Shows this help.\n"
    " -b        Do not run in background.\n"
    " -f file   Use file as config file.\n"
    " -d dir    Use dir as current dir.\n"
    " -D        Debug mode (input/output printing and no background mode.\n";
}

static void real_main(void* DONOTUSE, int argc, char **argv)
{
  int opt;
  extern char *optarg;
  bool background = true;
  String configFile = "bot.conf";
  String directory = "";
  bool debug = false;

  std::signal(SIGPIPE, SIG_IGN);
  std::signal(SIGALRM, SIG_IGN);
  std::signal(SIGHUP,  sig_hup);

  // We parse the command line options
  while ((opt = getopt(argc,argv,"hbf:d:D")) != EOF)
    switch (opt) {
    case 'h':
      printUsage(argv[0]); exit(0);
    case 'b':
      background = false;
      break;
    case 'f':
      configFile = optarg;
      break;
    case 'd':
      directory = optarg;
      break;
    case 'D':
      debug = true;
      break;
    default:
      printUsage(argv[0]); exit(1);
    }

  if ((directory != "") && (chdir((const char *)directory)<0))
    std::perror("Warning: ");

  std::cout << COPYRIGHT_STRING <<
    "\n"PACKAGE" comes with ABSOLUTELY NO WARRANTY\n"
    "This is free software, and you are welcome to redistribute it\n"
    "under certain conditions; See the COPYING file for details.\n";

  if (!debug) {
    if (background)
      switch (fork()) {
      case -1:
        std::cout << "Could not run in the background. Exiting...\n";
        perror("fork");
        exit(1);
      case 0:
        break;
      default:
        std::cout << "Running in the background...\n";
        exit(0);
      }
  }

#ifdef USESCRIPTS
  Interp::Startup();
#endif

  b = new Bot(configFile, debug);
  b->run();
  delete b;

#ifdef USESCRIPTS
  Interp::Shutdown();
#endif
}

int main(int argc, char **argv) {
#ifdef USESCRIPTS
  scm_boot_guile (argc, argv, real_main, 0);
#else
  real_main(0, argc, argv);
#endif

  return 0;
}
