// Interp.C  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD
// Copyright (C) 2002 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef USESCRIPTS

#include "Macros.H"
#include "Commands.H"
#include "Interp.H"
#include "BotInterp.H"

#include <libguile.h>

Bot * Interp::bot = 0;
#ifdef MULTITHREAD
pthread_mutex_t Interp::mutex = PTHREAD_MUTEX_INITIALIZER;
#endif

typedef SCM (*SCMFunc)();

SCM
scm_apply_wrapper(void *data)
{
  wrapper_data * wd = static_cast<wrapper_data *> (data);
  scm_apply(wd->func, wd->args, SCM_EOL);
  return SCM_BOOL_T;
}

#define bot_new_procedure(a, b, c, d, e) scm_c_define_gsubr (a, c, d, e, b)

void
Interp::Startup()
{
//  scm_primitive_load_path(scm_makfrom0str("ice-9/boot-9.scm"));

  bot_new_procedure ("bot-action", (SCMFunc)ScriptCommands::Action, 2, 0, 0);
  scm_c_define_gsubr ("bot-adduser", 5, 2, 0,
		      (SCMFunc)ScriptCommands::AddUser);
  bot_new_procedure ("bot-addserver", (SCMFunc)ScriptCommands::Action, 
		     3, 4, 0);
  scm_c_define_gsubr ("bot-addshit", 3, 2, 0, 
		      (SCMFunc)ScriptCommands::AddShit);
  bot_new_procedure ("bot-ban", (SCMFunc)ScriptCommands::Action, 2, 0, 0);
  bot_new_procedure ("bot-cycle", (SCMFunc)ScriptCommands::Action, 1, 0, 0);
  bot_new_procedure ("bot-deban", (SCMFunc)ScriptCommands::Deban, 2, 0, 0);
  bot_new_procedure ("bot-delserver", (SCMFunc)ScriptCommands::DelServer, 
		     1, 0, 0);
  bot_new_procedure ("bot-deluser", (SCMFunc)ScriptCommands::DelUser, 2, 0, 0);
  bot_new_procedure ("bot-delshit", (SCMFunc)ScriptCommands::DelShit, 2, 0, 0);
  bot_new_procedure ("bot-deop", (SCMFunc)ScriptCommands::Deop, 2, 0, 0);
  bot_new_procedure ("bot-die", (SCMFunc)ScriptCommands::Die, 1, 0, 0);
  bot_new_procedure ("bot-do", (SCMFunc)ScriptCommands::Do, 1, 0, 0);
  bot_new_procedure ("bot-invite", (SCMFunc)ScriptCommands::Invite, 2, 0, 0);
  bot_new_procedure ("bot-join", (SCMFunc)ScriptCommands::Join, 1, 1, 0);
  bot_new_procedure ("bot-keep", (SCMFunc)ScriptCommands::Keep, 2, 0, 0);
  bot_new_procedure ("bot-kick", (SCMFunc)ScriptCommands::Kick, 2, 1, 0);
  bot_new_procedure ("bot-kickban", (SCMFunc)ScriptCommands::KickBan, 2, 1, 0);
  bot_new_procedure ("bot-lock", (SCMFunc)ScriptCommands::Lock, 1, 0, 0);
  bot_new_procedure ("bot-logport", (SCMFunc)ScriptCommands::LogPort, 0, 0, 0);
  bot_new_procedure ("bot-mode", (SCMFunc)ScriptCommands::Mode, 2, 0, 0);
  bot_new_procedure ("bot-msg", (SCMFunc)ScriptCommands::Msg, 2, 0, 0);
  bot_new_procedure ("bot-nextserver", (SCMFunc)ScriptCommands::NextServer, 
		     0, 0, 0);
  bot_new_procedure ("bot-nick", (SCMFunc)ScriptCommands::Nick, 1, 0, 0);
  bot_new_procedure ("bot-op", (SCMFunc)ScriptCommands::Op, 2, 0, 0);
  bot_new_procedure ("bot-part", (SCMFunc)ScriptCommands::Part, 1, 0, 0);
  bot_new_procedure ("bot-reconnect", (SCMFunc)ScriptCommands::Reconnect, 
		     0, 0, 0);
  bot_new_procedure ("bot-say", (SCMFunc)ScriptCommands::Say, 2, 0, 0);
  bot_new_procedure ("bot-server", (SCMFunc)ScriptCommands::Server, 1, 0, 0);
  bot_new_procedure ("bot-setversion", (SCMFunc)ScriptCommands::SetVersion, 
		     1, 0, 0);
  bot_new_procedure ("bot-tban", (SCMFunc)ScriptCommands::TBan, 3, 0, 0);
  bot_new_procedure ("bot-tkban", (SCMFunc)ScriptCommands::TKBan, 3, 1, 0);
  bot_new_procedure ("bot-topic", (SCMFunc)ScriptCommands::Topic, 2, 0, 0);
  bot_new_procedure ("bot-unlock", (SCMFunc)ScriptCommands::Unlock, 1, 0, 0);

  bot_new_procedure ("bot-getnickname", (SCMFunc)ScriptCommands::getNickname, 
		     0, 0, 0);
  bot_new_procedure ("bot-getserver", (SCMFunc)ScriptCommands::getServer, 
		     0, 0, 0);
  bot_new_procedure ("bot-getserverlist", 
		     (SCMFunc)ScriptCommands::getServerList, 0, 0, 0);
  bot_new_procedure ("bot-flush", (SCMFunc)ScriptCommands::flushQueue, 
		     0, 0, 0);
  bot_new_procedure ("bot-flushport", (SCMFunc)ScriptCommands::flushPort, 
		     0, 0, 0);
  bot_new_procedure ("bot-random", (SCMFunc)ScriptCommands::random, 
		     1, 0, 0);
  bot_new_procedure ("bot-addcommand", (SCMFunc)ScriptCommands::addCommand, 
		     5, 0, 0);
  bot_new_procedure ("bot-delcommand", (SCMFunc)ScriptCommands::delCommand, 
		     1, 0, 0);
  bot_new_procedure ("bot-addhook", (SCMFunc)ScriptCommands::AddHook, 
		     3, 0, 0);
  bot_new_procedure ("bot-addtimer", (SCMFunc)ScriptCommands::AddTimer, 
		     2, 0, 0);
  bot_new_procedure ("bot-deltimer", (SCMFunc)ScriptCommands::DelTimer, 
		     1, 0, 0);
  scm_c_define ("hooks/action", scm_long2num(Hook::ACTION));
  scm_c_define ("hooks/nickname", scm_long2num(Hook::NICKNAME));
  scm_c_define ("hooks/signoff", scm_long2num(Hook::SIGNOFF));
  scm_c_define ("hooks/ctcp", scm_long2num(Hook::CTCP));
  scm_c_define ("hooks/ctcp-reply", scm_long2num(Hook::CTCP_REPLY));
  scm_c_define ("hooks/disconnect", scm_long2num(Hook::DISCONNECT));
  scm_c_define ("hooks/flood", scm_long2num(Hook::FLOOD));
  scm_c_define ("hooks/invite", scm_long2num(Hook::INVITE));
  scm_c_define ("hooks/join", scm_long2num(Hook::JOIN));
  scm_c_define ("hooks/kick", scm_long2num(Hook::KICK));
  scm_c_define ("hooks/leave", scm_long2num(Hook::LEAVE));
  scm_c_define ("hooks/part", scm_long2num(Hook::LEAVE));
  scm_c_define ("hooks/mode", scm_long2num(Hook::MODE));
  scm_c_define ("hooks/message", scm_long2num(Hook::MESSAGE));
  //  scm_c_define ("hooks/names", scm_long2num(Hook::NAMES));
  scm_c_define ("hooks/notice", scm_long2num(Hook::NOTICE));
  scm_c_define ("hooks/public", scm_long2num(Hook::PUBLIC));
  scm_c_define ("hooks/public-notice", scm_long2num(Hook::PUBLIC_NOTICE));
  scm_c_define ("hooks/raw", scm_long2num(Hook::RAW));
  scm_c_define ("hooks/timer", scm_long2num(Hook::TIMER));
  scm_c_define ("hooks/topic", scm_long2num(Hook::TOPIC));
}

void
Interp::Shutdown()
{ }

void
Interp::Execute(Bot *b, String command)
{
#ifdef MULTITHREAD
  // We get the lock
  pthread_mutex_lock(&mutex);
#endif
  bot = b;
  gh_eval_str_with_catch(command, ErrorHandler);
#ifdef MULTITHREAD
  // We release the lock
  pthread_mutex_unlock(&mutex);
#endif
}

void
Interp::LoadScript(Bot *b, String filename)
{
#ifdef MULTITHREAD
  // We get the lock
  pthread_mutex_lock(&mutex);
#endif
  bot = b;
  gh_eval_file_with_catch(filename, ErrorHandler);
#ifdef MULTITHREAD
  // We release the lock
  pthread_mutex_unlock(&mutex);
#endif
}

SCM
Interp::ErrorHandler(void *data, SCM tag, SCM throw_args)
{
  bot->botInterp->ScriptLog(throw_args);
  return SCM_BOOL_F;
}

#endif
