#!/bin/bash

# This script is part of the BasicMathEval Library - version 1.0
# Copyright (C)  2015, 2016    Ivano Primi ( ivprimi@libero.it )    

# The BasicMathEval Library is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# The BasicMathEval library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this software.  If not, see <http://www.gnu.org/licenses/>.

# DIFF="diff -U 40 "
DIFF="kdiff3"
TEST_OUTPUT=./test_output
REF_OUTPUT=./ref_output
DIFF_OUTPUT=./diff_output
PAGER=less

./testVartable
EXIT_CODE=$?
if [ ${EXIT_CODE} -eq 0 ]; then
    echo ""
    echo "+++ [OK]  First test succeeded"
    echo ""
else
    echo ""
    echo "*** [ERR] The test of the class variablesTable failed"
    echo ""
    exit ${EXIT_CODE}
fi

cat ./exprlist.no_tabs | ./test_program > ${TEST_OUTPUT} 2>&1
cmp ${REF_OUTPUT} ${TEST_OUTPUT}
# ${DIFF} ${REF_OUTPUT} ${TEST_OUTPUT} > ${DIFF_OUTPUT}
EXIT_CODE=$?
if [ ${EXIT_CODE} -eq 0 ]; then
    echo ""
    echo "+++ [OK]  Second test successfully executed,"
    echo "          test output and reference do coincide"
    echo ""
elif [ ${EXIT_CODE} -eq 1 ]; then
    echo ""
    echo "*** [ERR] Second test failed: test output and reference differ"
    ${DIFF} ${REF_OUTPUT} ${TEST_OUTPUT}
#    echo "*** [ERR] Test output and reference differ,"
#    read -p "***       Press [Enter] key to watch the list of all differences  "
#    ${PAGER} ${DIFF_OUTPUT}
else
    echo ""
    echo "*** [ERR] Failure while executing command"
    echo "***       ${DIFF} ${REF_OUTPUT} ${TEST_OUTPUT}"
    echo ""
fi

rm -f ${DIFF_OUTPUT}
exit ${EXIT_CODE}


