/*
   This file is part of the BasicMathEval Library - version 1.0
   Copyright (C)  2015, 2016    Ivano Primi ( ivprimi@libero.it )    

   The BasicMathEval Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The BasicMathEval library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _TRANSLATOR_H_
#define _TRANSLATOR_H_

#include "mathToken.h"
#include <map>
#include <queue>
#include <stack>

namespace bmEval 
{
  class translator
  {
  public:
    // Default constructors and destructor are fine
    std::queue<mathToken> translate (const std::vector<mathToken>& tokenSequence);

  private:
    typedef enum {
      LEFT_TO_RIGHT = 0,
      RIGHT_TO_LEFT = 1,
      NOT_DEFINED = -1
    } grouping;
  
    static grouping getGroupingOf (mathToken token)
    {
      if ( (token.isOperator()) )
	return sm_groupingTable[token.Type()];
      else
	return NOT_DEFINED;
    }

    static int getPriorityOf (mathToken token)
    {
      if ( (token.isFunction()) )
	return 10;
      else if ( (token.isOperator()) )
	return sm_priorityTable[token.Type()];
      else
	return -1;
    }

    void purgeOperatorStack ()
    {
      while (!m_operatorStack.empty())
	{
	  m_operatorStack.pop();	      
	}
    }

    static std::map<mathToken::tokenType, grouping> createGroupingTable ();
    static std::map<mathToken::tokenType, int> createPriorityTable ();

    static std::map<mathToken::tokenType, grouping> sm_groupingTable;
    static std::map<mathToken::tokenType, int> sm_priorityTable;
    std::stack<mathToken> m_operatorStack;
  };
} // end of namespace bmEval

#endif // _TRANSLATOR_H_
