/*
   This file is part of the BasicMathEval Library - version 1.0
   Copyright (C)  2015, 2016    Ivano Primi ( ivprimi@libero.it )    

   The BasicMathEval Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The BasicMathEval library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software.  If not, see <http://www.gnu.org/licenses/>.
*/
#include<iostream>
#include<cstring>

using namespace std;

/* The macros VERSION, IPATH and LPATH are directly defined on the */
/* command line to the compiler.                                   */

#ifndef VERSION
#define VERSION "unknown"
#endif

#ifndef PREC
#define PREC ""
#endif

#ifndef IPATH
#define IPATH ""
#endif

#ifndef LPATH
#define LPATH ""
#endif

#ifndef LIBS
#define LIBS ""
#endif

void print_usage (const char* progname)
{
  cerr << "*** Usage:  " << progname << " [-v] [-n] or" << endl;
  cerr << "***         " << progname << " [-c] [-l] [-n]\n" << endl;
  cerr << "*** Meaning of the options:" << endl;
  cerr << "    -v      return the current version of BasicMathEval" << endl;
  cerr << "    -c      return flags for compiling source code relying on BasicMathEval" << endl;
  cerr << "    -l      return flags for linking against BasicMathEval" << endl;
  cerr << "    -n      insert a newline at the end of the printed information\n" << endl;
}

/* Possible options: -v, -c, -l, -n */

int main (int argc, char* argv[])
{
  int i;
  unsigned char flag = 0;
  unsigned char v, c, l, n;

  if ( argc == 1)
    {
      print_usage(argv[0]);
      return 0;
    }
  else if ( argc > 5 )
    {
      print_usage(argv[0]);
      return 1;
    }
  else
    {
      for (i=1; i<argc; i++)
	{
	  if ( strcmp ("-v", argv[i]) == 0 )
	    {
	      if (flag != 0 && flag != 8)
		{
		  print_usage(argv[0]);
		  return 1;
		}
	      else
		flag += 1;
	    }
	  else if ( strcmp ("-c", argv[i]) == 0 )
	    {
	      if ((flag % 2 == 1) || ((flag >> 1) % 2 == 1))
		{
		  print_usage(argv[0]);
		  return 1;
		}
	      else
		flag += 2;
	    }
	  else if ( strcmp ("-l", argv[i]) == 0 )
	    {
	      if ((flag % 2 == 1) || ((flag >> 2) % 2 == 1))
		{
		  print_usage(argv[0]);
		  return 1;
		}
	      else
		flag += 4;
	    }
	  else if ( strcmp ("-n", argv[i]) == 0 )
	    {
	      if ((flag >> 3) % 2 == 1)
		{
		  print_usage(argv[0]);
		  return 1;
		}
	      else
		flag += 8;
	    }
	  else
	    {
	      print_usage(argv[0]);
	      return 1;
	    }
	} /* end for */
      v = flag % 2;
      c = (flag >> 1) % 2;
      l = (flag >> 2) % 2;
      n = (flag >> 3) % 2;
      if ( (v) )
	{
	  cout << VERSION;
	}
      if ( (c) )
	{
	  cout << PREC << ' ' << IPATH << ' ';
	}
      if ( (l) )
	{
	  cout << LPATH << " -lbmEval " << LIBS;
	}
      if ( (n) )
	{
	  cout << endl;
	}
      else
	{
	  cout.flush();
	}
      return 0;
    } /* end else */
} 
