/*
   This file is part of the BasicMathEval Library - version 1.0
   Copyright (C)  2015, 2016    Ivano Primi ( ivprimi@libero.it )    

   The BasicMathEval Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The BasicMathEval library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _BASIC_CALCULATOR_
#define _BASIC_CALCULATOR_

#include <map>
#include "evalError.h"
#include "mathToken.h"
#include "variablesTable.h"

namespace bmEval {
  class basicCalculator 
  {
  public:
    basicCalculator (variablesTable& table,
		     bool allowForComplexArithmetic = true) :
      m_rVTable (table), 
      m_isComplexArithmeticAllowed (allowForComplexArithmetic),
      m_lastError ()
    {}

    basicCalculator (const basicCalculator& obj) :
      m_rVTable (obj.m_rVTable), 
      m_isComplexArithmeticAllowed (obj.m_isComplexArithmeticAllowed),
      m_lastError (obj.m_lastError)
    {}

    basicCalculator& operator= (const basicCalculator& rhs)
      {
	if (this != &rhs)
	  {
	    m_rVTable = rhs.m_rVTable;
	    m_isComplexArithmeticAllowed = rhs.m_isComplexArithmeticAllowed;
	    m_lastError = rhs.m_lastError;
	  }
	return *this;
      }
    // Default destructor is fine

    void allowForComplexArithmetic (bool yesno) {
      m_isComplexArithmeticAllowed = yesno;
    }

    const evalError& getLastError () const {
      return m_lastError;
    }

    void eraseLastError () {
      m_lastError.clear();
    }
    
    void evaluateBinaryOperator (const mathToken& operation, 
				 const mathToken& arg1, const mathToken& arg2, 
				 mathToken& result);
    void evaluateAssignmentOperator (const mathToken& operation, 
				     const mathToken& arg1, const mathToken& arg2, 
				     mathToken& result);
    void evaluateFunction (const mathToken& function, 
			   const mathToken& arg, 
			   mathToken& result);

  private:
    typedef mathToken (*mathFunction) (cValue, size_t);
    typedef mathToken (*binaryOperator) (cValue, cValue, size_t);

    static std::map<mathToken::tokenType, mathFunction> createFnTable ();
    static std::map<mathToken::tokenType, binaryOperator> createOpTable ();

    static std::map<mathToken::tokenType, mathFunction> sm_fnTable;
    static std::map<mathToken::tokenType, binaryOperator> sm_opTable;

    variablesTable& m_rVTable;
    bool m_isComplexArithmeticAllowed;
    evalError m_lastError;
  };
} // end of namespace bmEval

#endif // _BASIC_CALCULATOR_
