/*
   This file is part of the BasicMathEval Library - version 1.0
   Copyright (C)  2015, 2016    Ivano Primi ( ivprimi@libero.it )    

   The BasicMathEval Library is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   The BasicMathEval library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this software.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _UTILS_H_
#define _UTILS_H_

//#include <mgl2/define.h>
#include <string>
#include "mathToken.h"

namespace bmEval
{
  class Utils {
  public:
    enum {
      CONVERSION_DONE = 0,
      OVERFLOW_OCCURRED = 1,
      NOT_A_VALUE = 2
    };

    static const char imaginaryUnit = 'i';

    //    static bool isSpace (char ch) { return (ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r' || ch == '\f' || ch == '\v'); }
    static bool doesStartWithId (const std::string& str, size_t& idx);
    static bool doesStartWithSymbols (const std::string& str, size_t& idx)
    {
      for (idx = 0; idx < str.length() && isSymbol(str[idx]) == true; idx++);
      return (idx > 0);
    }

    static size_t posOfFirstSpace (const std::string& str, size_t startingFrom = 0)
    {
      return str.find_first_of (" \t\n\r\f\v", startingFrom); 
    }

    static size_t posOfFirstNonSpace (const std::string& str, size_t startingFrom = 0)
    {
      return str.find_first_not_of (" \t\n\r\f\v", startingFrom); 
    }

    // The following function is only used in case implicit multiplication is allowed
    static bool doesIdOrOpenParenthesisFollow (const std::string& str, size_t position)
    {
      // First skip any possible leading space,
      position = Utils::posOfFirstNonSpace (str, position);
      // then check the type of the first non-space character and
      // return a boolean value accordingly.
      return ( position != std::string::npos && 
	       (str[position] == mathToken::oParenthesis || str[position] == '_' || isAlpha (str[position])) );
    }

    static std::string n2str (size_t n);

    // if STR is an empty string (up to white space characters),
    // then all these functions return zero.
    static long str2l (const std::string& str, size_t& idx, int& errorCode, int base = 10);
    static unsigned long str2ul (const std::string& str, size_t& idx, int& errorCode, int base = 10);
    static rValue str2r (const std::string& str, size_t& idx, int& errorCode);
    static cValue str2c (const std::string& str, size_t& idx, int& errorCode);

    static bool isNotZero (rValue x) { return (x < -1.0e-30 || x > 1.0e-30 ); } 

  private:
    static bool isDigit (char ch) { return (ch >= '0' && ch <= '9'); }
    static bool isAlpha (char ch);
    static bool isSymbol (char ch) { return (ch == '+' || ch == '-' || ch == '*' || ch == '/' || ch == '^' ||
					     ch == '=' || ch == '<' || ch == '>' || ch == '!' || ch == '%' ||  
					     ch == '&' || ch == '|' || ch == ':' || ch == '~'); }
  };
} // end of namespace bmEval

#endif // _UTILS_H_
