/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include <bit/fieldbuffer.h>
#include <iostream>
#include <iomanip>
#include <netinet/in.h>

using namespace bit;
using namespace std;

// enum for manual code
// enum {
//   ip_VERSION,     // 0      4
//   ip_IHL,         // 4      4
//   ip_TOS,         // 8      8
//   ip_TL,          // 16    16
//   ip_ID,          // 32    16
//   ip_FLAGS,       // 48     3
//   ip_FRAGOFF,     // 51    13
//   ip_TTL,         // 64     8
//   ip_PROTOCOL,    // 72     8
//   ip_CHECKSUM,    // 80    16
//   ip_SOURCE,      // 96    32
//   ip_DESTINATION, // 128   32
//   udp_SRCPORT,    // 160   16
//   udp_DESTPORT,   // 176   16
//   udp_LENGTH,     // 192   16
//   udp_CHECKSUM,   // 208   16
//   udp_DATA,       // 224
// };

/*
Should result in the following
               IP Version:   0x00000004
IP Internet Header Length:   0x00000005
       IP Type of Service:   0x00000000
          IP Total Length:   0x0000002b
        IP Identification:   0x00001b45
                 IP Flags:   0x00000000
       IP Fragment Offset:   0x00000000
          IP Time to Live:   0x000000ff
              IP Protocol:   0x00000011
              IP Checksum:   0x0000956e
                IP Source:   0x0a05010a
           IP Destination:   0xffffffff
          UDP Source Port:   0x00000406
     UDP Destination Port:   0x00000bbb
               UDP Length:   0x00000017
             UDP Checksum:   0x0000e4f0
*/

int main()
{
  FieldBuffer buffer;
  Tuple fields;
  uint32_t extracted;
  uint8_t data[] = {
                     // IP Header
                     0x45, 0x00, 0x00, 0x2b, 0x1b, 0x45, 0x00, 0x00, 0xff, 0x11, 0x95, 0x6e, 0x0a, 0x05, 0x01, 0x0a, 0xff, 0xff, 0xff, 0xff,
                     // UDP Header
                     0x04, 0x06, 0x0b, 0xbb, 0x00, 0x17, 0xe4, 0xf0,
                     // Data
                     0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
                   };

  /**
   * Or load from an XML file
   */
    fields.load_xml("udp.xml");

  /**
   * Set the working buffer to use the fields set
   */
  buffer.set_fields(fields);

  /**
   * Point the working buffer to the data buffer
   */
  buffer.set_data(&data, sizeof(data));

  cout << fields.name() << std::endl
  << "\tDescription: " << fields.description() << std::endl
  << "\tFields:      " << fields.size() << std::endl;

  /**
   * Iterate through the field enumeration and extract each field into a 32-bit unsigned integer.
   */
  for (unsigned x = 0; x < fields.size(); x++)
    {
      extracted = 0x00;
      std::cout << fields[x].name() << std::endl;

      for (int y=0; y < fields[x].size(); y++)
        {
          /** Extract using fields number and template method */
          extracted = buffer[x][y];

          /** Perform any byte swapping necessary to convert from network to host order. */
          extracted = ntohl(extracted);
          cout << "     " << dec << "[" << setfill(' ') << setw(4) << fields[x][y].start()
          << ", " << setw(4) << fields[x][y].bits() << "] "
          << setfill(' ') << setw(25) << setiosflags(ios::right) << fields[x][y].full_name(fields[x][y].depth()-1)
          << "(" << fields[x][y].id() << ")"
          << ":   0x" << hex << setfill('0') << setw(8) << extracted << endl;
          /*          if (fields[f].description().size() > 0)
                      cout << "  " << fields[f].description() << std::endl << std::endl;*/
        }
    }

  //     extracted = 0x00;
  //     extracted = buffer["IP.TL"];
  //     extracted = ntohl(extracted);
  //     cout << "     " << dec << "[" << setfill(' ') << setw(4) << fields["IP.TL"].start()
  //         << ", " << setw(4) << fields["IP.TL"].bits() << "] "
  //         << setfill(' ') << setw(25) << setiosflags(ios::right) << fields["IP.TL"].full_name(fields["IP.TL"].depth()-1)
  //         << ":   0x" << hex << setfill('0') << setw(8) << extracted << endl;

  TupleBase::iterator i;
  for (i = fields.begin(); i != fields.end(); ++i)
    {
      std::cout << i->name() << std::endl;
    }

    std::cout << "XML: " << std::endl
        << fields.get_xml() << std::endl;

}
