/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "bufferlist.h"

using namespace bitgtk;

BufferList::BufferList()
    : Gtk::EventBox(), m_buffer(NULL), m_table(NULL)
{
  create_table();
}


BufferList::~BufferList()
{}

void BufferList::set_buffer( bit::FieldBuffer & buffer )
{
  m_buffer = &buffer;
  buffer.signal_field_changed().connect(sigc::mem_fun(*this, &BufferList::on_buffer_field_changed));
  buffer.signal_fields_changed().connect(sigc::mem_fun(*this, &BufferList::on_buffer_fields_changed));
  on_buffer_changed();
}

void BufferList::on_buffer_changed( )
{
  std::ostringstream text;
  std::string name;
  Gtk::Label* label;
  Gtk::EventBox* eventbox;

  if (m_buffer == NULL)
    return;

  create_table();
  m_label.clear();

  size_t row = 0;
  for (bit::TupleBase::iterator iter = m_buffer->fields().begin(); iter != m_buffer->fields().end(); row++, iter++) {
    name = iter->full_name(iter->depth()-1);
      label = Gtk::manage(new Gtk::Label());
      text.str("");
      text << "<big><b>" << name << "</b></big>";
      label->set_justify(Gtk::JUSTIFY_LEFT);
      label->set_use_markup();
      label->set_markup(text.str());
      eventbox = Gtk::manage(new Gtk::EventBox());
      eventbox->add(*label);
      if (iter->description().size() > 0 )
        m_tooltips.set_tip(*eventbox, iter->description());
      m_table->attach(*eventbox, 0, 1, row, row+1);
      label = Gtk::manage(new Gtk::Label());
      label->set_justify(Gtk::JUSTIFY_LEFT);
      eventbox = Gtk::manage(new Gtk::EventBox());
      eventbox->add(*label);
      if (iter->description().size() > 0 )
        m_tooltips.set_tip(*eventbox, iter->description());
      m_table->attach(*eventbox, 1, 2, row, row+1);
      m_label[ name ] = label;
      on_buffer_field_changed(name);
  }
}

void BufferList::on_buffer_field_changed( std::string name )
{
  std::ostringstream text;
  bit::Data data;
  bit::FieldBuffer& buffer = *m_buffer;

  text.str("");
  data = buffer[name].data();
  std::string s = data.octet_string();
  text << " <tt>0x" << s << "</tt> ";
  m_label[ name ]->set_use_markup();
  m_label[ name ]->set_markup(text.str());
}


void BufferList::on_buffer_fields_changed( )
{
  std::ostringstream text;
  bit::Data data;
  bit::FieldBuffer& buffer = *m_buffer;

  for (bit::TupleBase::iterator iter = buffer.fields().begin(); iter != buffer.fields().end(); iter++) {
    text.str("");
    data = buffer[iter->full_name(iter->depth()-1)].data();
    std::string s = data.octet_string();
    text << " <tt>0x" << s << "</tt> ";
    m_label[ iter->full_name(iter->depth()-1) ]->set_use_markup();
    m_label[ iter->full_name(iter->depth()-1) ]->set_markup(text.str());
  }

}

void BufferList::create_table( )
{
  if (m_table != NULL)
    remove
      ();

  m_table = Gtk::manage(new Gtk::Table());
  m_table->set_homogeneous();
  m_table->set_spacings(3);
  add
    (*m_table);
}

void BufferList::enable_tooltips( bool b )
{
  if (b)
    m_tooltips.enable();
  else
    m_tooltips.disable();
}

