/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef BITTUPLE_H
#define BITTUPLE_H

#include <string>
#include <map>
#include <vector>

#include <libxml++/libxml++.h>

#include <bit/field.h>

namespace bit
  {
  class Tuple: public TupleBase
    {
    public:
      Tuple(unsigned id=0, std::string name="", size_t offset=0, std::string descr="", size_t size=1);
      
      Tuple(TupleBase& parent, unsigned id=0, std::string name="", size_t offset=0, std::string descr="", size_t size=1);
      
      Tuple(std::string filename);
      
      ~Tuple();

      Tuple& operator=(const Tuple& other);
      TupleBase& operator[](size_t field_id);
      TupleBase& operator[](std::string field_id);

      virtual int get_index(std::string name) throw ();

      virtual void load_xml(std::string filename);

      virtual size_t bits() const;
      
      size_t read(xmlpp::Element& xml_element, size_t last_position);
      virtual std::string get_xml();

      void set_name(const std::string& value);
      std::string name() const;

      void set_description(const std::string& value);
      std::string description() const;

      virtual size_t size() const;
      virtual void set_size(const size_t& value);

    protected:
      typedef std::vector<sptrTupleBase> FieldContainer;
      typedef std::map<std::string, unsigned> NameMap;

      size_t m_size;
      std::string m_name;
      std::string m_description;
      FieldContainer m_fields;
      NameMap m_namemap;
      bool m_is_vector;

      std::string children_xml();
      
    };

  typedef boost::shared_ptr<Tuple> sptrTuple;
  
}

#endif
