/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef BITINDICES_ERROR_H
#define BITINDICES_ERROR_H

#include <sstream>

#include <bit/error.h>

namespace bit
  {

  /**
   * Base class for all indices errors.
   * @author Rick L Vinyard Jr
   * @ingroup errors
   */
  class indices_error: public bit_error
    {
    public:
      indices_error(): bit_error("bit:Indices: Unknown error.")
      { }
      indices_error(const std::string s): bit_error(s)
      { }
    }
  ;

  namespace error
    {


    namespace indices
      {

      /**
       * Invalid numeric indices identifier
       * @author Rick L Vinyard Jr
       * @ingroup errors
       */
      class invalid_numeric_id: public indices_error
        {
        public:
          invalid_numeric_id(): indices_error("bit:Indices: Invalid numeric identifier, index not found.")
          { }
          invalid_numeric_id(unsigned int id): indices_error("bit:Indices: Invalid numeric identifier, index not found.")
          {
            std::ostringstream sout;
            sout << "bit:Indices: No index with numeric identifier (" << id << ")";
            m_error_string = sout.str();
          }
        }
      ;

      /**
       * Invalid string indices identifier
       * @author Rick L Vinyard Jr
       * @ingroup errors
       */
      class invalid_string_id: public indices_error
        {
        public:
          invalid_string_id(): indices_error("bit:Indices: Invalid string identifier, index not found.")
          { }
          invalid_string_id(std::string s): indices_error("bit:Indices: Invalid numeric identifier, index not found.")
          {
            m_error_string = "bit:Indices: No index with string identifier (" + s + ")";
          }
        }
      ;


    }
  }
}
#endif
