/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef BITELEMENT_H
#define BITELEMENT_H

#include <bit/tuplebase.h>
#include <bit/error.h>

namespace bit {

/**
@author Rick L. Vinyard, Jr.
*/
class Element : public TupleBase
{
public:
  Element(size_t id=0, size_t offset=0, size_t bits=0);
  Element(const Element& other);
  Element(TupleBase& parent, size_t id=0, size_t offset=0, size_t bits=0);

    ~Element();

  virtual std::string name() const;

  virtual std::string description() const;

  virtual size_t size() const;


  virtual TupleBase& operator[](size_t index);
  virtual TupleBase& operator[](std::string index);
  

};

typedef boost::shared_ptr<Element> sptrElement;

}

#endif
