/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef BSTREAM_H
#define BSTREAM_H

#include <stdexcept>

namespace bit {

/**
@author Rick L. Vinyard, Jr.
*/
/**
 * This class serves as a parent to ibstream and obstream providing basic facilities for maintaining up to a one octet buffer of bits.
 * It also provides endian management.
 */
class bstream {
public:
    bstream();

    ~bstream();

    //bool is_big_endian()                 { return m_big_endian; }
    //bool is_little_endian()              { return !m_big_endian; }
    bool is_host_big_endian()            {
        return m_host_big_endian;
    }
    bool is_host_little_endian()         {
        return !m_host_big_endian;
    }

    //void big_endian(bool b=true)         { m_big_endian = b; }
    //void little_endian(bool b=true)      { m_big_endian = !b; }
    void host_big_endian(bool b=true)    {
        m_host_big_endian = b;
    }
    void host_little_endian(bool b=true) {
        m_host_big_endian = !b;
    }

    typedef enum State {WHOLE, BITS, OCTETS} State;

  protected:
    //bool m_big_endian;
    bool m_host_big_endian;
    unsigned char m_leftoverbits;
    size_t  m_numleftoverbits;
    static const int m_masks[8];

    State m_state;
    size_t m_stateval;


};

class bits {
  public:
    bits(size_t n): val(n) { }
    int val;
};

class octets {
  public:
    octets(size_t n): val(n) { }
    int val;
};

class whole {
  public:
    whole() { }
};

}; // namespace bit

#endif
