/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <GL/glu.h>
#include "wipe.h"

@implementation Wipe

-(Wipe *) init
{
    self = [super init];
    
    return self;
}

-(void) cleanup
{
    double lambda;
    
    [super cleanup];

    lambda = self->delta / self->duration;
    
    if (self->delta < self->duration) {
	glMatrixMode (GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	glOrtho (0, 1, 0, 1, -1, 1);

	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity();

	glUseProgramObjectARB (0);
	glDepthMask (GL_FALSE);
    
	glEnable (GL_TEXTURE_2D);
	glBindTexture (GL_TEXTURE_2D, self->texture);
    
	glBegin (GL_QUADS);
	glTexCoord2f (0 - lambda, 0);
	glVertex2f (0 - lambda, 0);

	glTexCoord2f (1 - lambda, 0);
	glVertex2f (1 - lambda, 0);

	glTexCoord2f (1 - lambda, 1);
	glVertex2f (1 - lambda, 1);

	glTexCoord2f (0 - lambda, 1);
	glVertex2f (0 - lambda, 1);
	glEnd();
    
	glDisable (GL_TEXTURE_2D);
	glDepthMask(GL_TRUE);

	glMatrixMode (GL_PROJECTION);
	glPopMatrix();
    }
}

@end
