/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <time.h>
#include "toggle.h"

@implementation Toggle

-(Toggle *) init
{
    self = [super init];
    
    self->state = 0;
    
    return self;
}

-(void) get
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "state")) {
	lua_pushboolean (_L, self->state);
    } else if (!xstrcmp(k, "on")) {
	lua_rawgeti(_L, LUA_REGISTRYINDEX, self->on);
    } else if (!xstrcmp(k, "off")) {
	lua_rawgeti(_L, LUA_REGISTRYINDEX, self->off);
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "state")) {
	if (self->state != lua_toboolean (_L, -1)) {
	    self->state = lua_toboolean (_L, -1);
	
	    [self toggle];

	    if (self->state) {
		/* Unlink off. */
		
		if (self->off != LUA_REFNIL) {    
		    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->off);
		    lua_pushliteral (_L, "parent");
		    lua_pushnil (_L);
		    lua_settable (_L, -3);
		    lua_pop (_L, 1);
		}
	
		/* Link on. */
		
		if (self->on != LUA_REFNIL) {    
		    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->on);
		    lua_pushliteral (_L, "parent");

		    lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
		    lua_pushlightuserdata (_L, self);
		    lua_gettable (_L, -2);
		    lua_replace (_L, -2);

		    lua_settable (_L, -3);
		    lua_pop (_L, 1);
		}
	    } else {
		/* Unlink on. */
		
		if (self->on != LUA_REFNIL) {    
		    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->on);
		    lua_pushliteral (_L, "parent");
		    lua_pushnil (_L);
		    lua_settable (_L, -3);
		    lua_pop (_L, 1);
		}
		
		/* Link off. */
		
		if (!self->state && self->off != LUA_REFNIL) {    
		    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->off);
		    lua_pushliteral (_L, "parent");

		    lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
		    lua_pushlightuserdata (_L, self);
		    lua_gettable (_L, -2);
		    lua_replace (_L, -2);

		    lua_settable (_L, -3);
		    lua_pop (_L, 1);
		}
	    }
	}
    } else if (!xstrcmp(k, "on")) {
	/* Make sure we're unlinked. */
	
	if (self->on != LUA_REFNIL) {    
	    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->on);
	    lua_pushliteral (_L, "parent");
	    lua_pushnil (_L);
	    lua_settable (_L, -3);
	    lua_pop (_L, 1);
	}
	
	luaL_unref (_L, LUA_REGISTRYINDEX, self->on);
	self->on = luaL_ref (_L, LUA_REGISTRYINDEX);

	/* Link if needed. */
	
	if (!self->state && self->on != LUA_REFNIL) {    
	    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->on);
	    lua_pushliteral (_L, "parent");

	    lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
	    lua_pushlightuserdata (_L, self);
	    lua_gettable (_L, -2);
	    lua_replace (_L, -2);

	    lua_settable (_L, -3);
	    lua_pop (_L, 1);
	}
    } else if (!xstrcmp(k, "off")) {
	/* Make sure we're unlinked. */
	
	if (self->off != LUA_REFNIL) {    
	    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->off);
	    lua_pushliteral (_L, "parent");
	    lua_pushnil (_L);
	    lua_settable (_L, -3);
	    lua_pop (_L, 1);
	}
	
	luaL_unref (_L, LUA_REGISTRYINDEX, self->off);
	self->off = luaL_ref (_L, LUA_REGISTRYINDEX);

	/* Link if needed. */
	
	if (!self->state && self->off != LUA_REFNIL) {    
	    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->off);
	    lua_pushliteral (_L, "parent");

	    lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
	    lua_pushlightuserdata (_L, self);
	    lua_gettable (_L, -2);
	    lua_replace (_L, -2);

	    lua_settable (_L, -3);
	    lua_pop (_L, 1);
	}
    } else {
	[super set];
    }
}

@end

