/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "system.h"
#include "composite.h"

@implementation Composite

-(Composite *) init
{
    self->composite = dSimpleSpaceCreate (NULL);
    dSpaceSetCleanup (self->composite, 0);

    [super init];

    return self;
}

-(void) fasten
{
    int i;
    dGeomID container;

    [super fasten];

    for (i = 0 ; i < dSpaceGetNumGeoms(self->composite) ; i += 1) {
	container = dSpaceGetGeom(self->composite, i);
	dGeomSetBody (container, NULL);
    }
}

-(void) release
{
    int i;
    dGeomID container;

    [super release];

    for (i = 0 ; i < dSpaceGetNumGeoms(self->composite) ; i += 1) {
	container = dSpaceGetGeom(self->composite, i);
	dGeomSetBody (container, self->body);
    }
}

-(void) free
{
    dSpaceDestroy ((dSpaceID)self->composite);
    self->composite = NULL;

    [super free];
}
 
-(void) setGeom: (dGeomID) new
{
}

-(void) insertInto: (dSpaceID) new
{
    if (self->space) {
	dSpaceRemove (self->space, (dGeomID)self->composite);
    }

    if (new) {
	dSpaceAdd (new, (dGeomID)self->composite);
    }
    
    self->space = new;
}
  
-(void) adopt: (id) child named: (char *) name
{
    dGeomID container;
    
    if ([child isKindOf: [Body class]]) {
	assert (![child space]);
	
	container = dCreateGeomTransform (NULL);

	dGeomTransformSetGeom (container, [child geom]);
	dGeomSetData (container, child);
	dGeomSetBody (container, self->body);
	dSpaceAdd (self->composite, container);

	[child fasten];
    }
    
    [super adopt: child named: name];
}

-(void) renounce: (id) child
{
    dGeomID container;
    int i;
    
    if ([child isKindOf: [Body class]]) {
	assert (![child space]);

	for (i = 0 ; i < dSpaceGetNumGeoms(self->composite) - 1 ; i += 1) {
	    container = dSpaceGetGeom(self->composite, i);

	    if (dGeomTransformGetGeom (container) == [child geom]) {
		dSpaceRemove (self->composite, container);
		dGeomDestroy(container);

		break;
	    }
	}

	assert (i != dSpaceGetNumGeoms(self->composite));

	[child release];
    }

    [super renounce: child];
}

@end
