/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _COMMON_H_
#define _COMMON_H_

#include <assert.h>
#include <lua.h>
#include <ode/ode.h>

lua_State *_L;
dWorldID _WORLD;
dSpaceID _SPACE;
dJointGroupID _GROUP;

#define BEGIN_ASSERT_BALANCED {		\
    int __h = lua_gettop (_L);

#define END_ASSERT_BALANCED		\
    assert (lua_gettop (_L) == __h);	\
    }

int xstrcmp (const char *a, const char *b);

#endif
