/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "display.h"

@implementation Display

-(void) transform
{
    id child;
    int i;

    /* Calculate our own allocation based on our children. */
    
    self->minimum[0] = 2 * self->padding[0];
    self->minimum[1] = 2 * self->padding[1];
    
    for(child = [self children] ; child ; child = [child sister]) {
	float width, height;

	width = [child width] + 2 * self->padding[0];
	height = [child height] + 2 * self->padding[1];
	
	self->minimum[0] = width > self->minimum[0] ?
	                   width : self->minimum[0];

	self->minimum[1] = height > self->minimum[1] ?
	                   height : self->minimum[1];
    }

    self->allocated[0] = self->minimum[0] > self->requested[0] ?
	                 self->minimum[0] : self->requested[0];
    self->allocated[1] = self->minimum[1] > self->requested[1] ?
	                 self->minimum[1] : self->requested[1];
	
    /* Now reset the children. */
    
    if([self children]) {
	GLfloat delta[3] = {0, 0, 0};

	/* Align the child properly. */
    
	if (self->align[0] < 0) {
	    delta[0] = 0.5 * (self->minimum[0] - self->allocated[0]);
	} else if (self->align[0] > 0) {
	    delta[0] = 0.5 * (self->allocated[0] - self->minimum[0]);
	} else {
	    delta[0] = 0;
	}

	if (self->align[1] < 0) {
	    delta[1] = 0.5 * (self->minimum[1] - self->allocated[1]);
	} else if (self->align[1] > 0) {
	    delta[1] = 0.5 * (self->allocated[1] - self->minimum[1]);
	} else {
	    delta[1] = 0;
	}

	[[self children] setPositionTo: delta];
    }

    /* Just return the position and orientation. */
	
    for (i = 0 ; i < 3 ; i += 1) {
	self->translation[i] = self->position[i];
    }

    for (i = 0 ; i < 9 ; i += 1) {
	self->rotation[i] = self->orientation[i];
    }

    /* Calculate the homogenous transform matrix. */
    
    self->homogenous[0] = self->rotation[0];
    self->homogenous[1] = self->rotation[3];
    self->homogenous[2] = self->rotation[6];
    self->homogenous[3] = 0;
    
    self->homogenous[4] = self->rotation[1];
    self->homogenous[5] = self->rotation[4];
    self->homogenous[6] = self->rotation[7];
    self->homogenous[7] = 0;
    
    self->homogenous[8] = self->rotation[2];
    self->homogenous[9] = self->rotation[5];
    self->homogenous[10] = self->rotation[8];
    self->homogenous[11] = 0;

    self->homogenous[12] = self->translation[0];
    self->homogenous[13] = self->translation[1];
    self->homogenous[14] = self->translation[2];
    self->homogenous[15] = 1;
    
    for(child = [self children] ; child ; child = [child sister]) {
	[child transform];
    }
}

-(void) traverseDeferred
{
    glMatrixMode (GL_PROJECTION);
    glPushMatrix();
    glLoadIdentity();

    glOrtho(-0.5, 0.5, -0.5, 0.5, 0, 1);
    glUseProgramObjectARB(0);

    [super traverse];
    
    glMatrixMode (GL_PROJECTION);
    glPopMatrix();
}

-(void) traverse
{
    [super deferTraversal];
}

@end
