-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

math.randomseed (os.clock())

billiards.history = {}

if options.eightball then
   local left, right, isplaced

   left, right = math.random (2, 8), math.random (10, 16)
   isplaced = {[2] = true, [9] = true, [left] = true, [right] = true}

   -- Set up the balls for eight-ball.

   billiards.opening[1] = {0.25 * billiards.tablewidth,
			   0,
			   billiards.ballradius}

   for j = 1, 5 do
      for i = 1, j do
	 local k, n

	 k = j * (j - 1) / 2 + i

	 if k == 1 then
	    n = 2
	 elseif k == 5 then
	    n = 9
	 elseif k == 11 then
	    n = left
	 elseif k == 15 then
	    n = right
	 else
	    repeat
	       n = math.random (3, 16)
	    until not isplaced[n]
	 end

	 isplaced[n] = true
	 
	 billiards.opening[n] = {-0.25 * billiards.tablewidth -
				 1.001 * billiards.ballradius * j * math.sqrt(3),
			         1.001 * billiards.ballradius * (2 * i - j - 1),
			         billiards.ballradius}
      end
   end
elseif options.nineball then
   local isplaced

   -- Set up the balls for nine-ball.

   isplaced = {[2] = true, [10] = true}

   billiards.opening[1] = {0.25 * billiards.tablewidth,
			   0,
			   billiards.ballradius}

   for j = 1, 5 do
      for i = 1, 3 - math.abs(j - 3) do
	 local k, n

	 k = j < 5 and j * (j - 1) / 2 + i or 9

	 if k == 1 then
	    n = 2
	 elseif k == 5 then
	    n = 10
	 else
	    repeat
	       n = math.random (3, 9)
	    until not isplaced[n]
	 end

	 isplaced[n] = true
	 
	 billiards.opening[n] = {-0.25 * billiards.tablewidth -
				 1.001 * billiards.ballradius * j * math.sqrt(3),
			         1.001 * billiards.ballradius * (2 * i +
							 math.abs(j - 3) - 4),
			         billiards.ballradius}
      end
   end
elseif options.carom then
   -- Set up the balls for carom.

   billiards.opening[1] = {0.25 * billiards.tablewidth,
			   0.1524,
			   billiards.ballradius}
   billiards.opening[2] = {0.25 * billiards.tablewidth,
			   0,
			   billiards.ballradius}
   billiards.opening[3] = {-0.25 * billiards.tablewidth,
			   0,
			   billiards.ballradius}
end   
