<!--
    Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
    This program is free software: you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation, either version 3 of the License, or    
    (at your option) any later version.                                  
    
    This program is distributed in the hope that it will be useful,      
    but WITHOUT ANY WARRANTY; without even the implied warranty of       
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
    GNU General Public License for more details.                         
                                                                     
    You should have received a copy of the GNU General Public License    
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<head>

  <title>Game</title>
  <link rel="stylesheet" href="stylesheet">

    <style type="text/css">
      col.first {width : 12em;}
      col.second {width : 7em ;}
    </style>

</head>

<body>

  <hr> 
  <h1>
    <object height=85 type="image/svg+xml" data="/logo">Billiards</object>
  </h1>
  
  <a href = "/">back</a>
  <hr> 

  <h1>New game</h1>

  <p>You can use the following links to start a new game.  Note that
    this only selects the proper table type and sets up the balls
    according to the specified game's opening positions. No rule checking
    or enforcement is implied.  Games which share the same opening setup
    (e.g. straight rail and cushion billiards) are therefore grouped
    together.
  </p>

  <p>Currently the following games are available.</p>

  <ul>
    <li> Pocket games
      <ul>
	<li>
	  <a href="/newgame?newgame=true&options.eightball=true&options.pool=true">
	    Eight-ball
	  </a>
	<li>
	  <a href="/newgame?newgame=true&options.nineball=true&options.pool=true">
	    Nine-ball
	  </a>
      </ul>
    <li> Pocketless games
      <ul>
	<li>
	  <a href="/newgame?newgame=true&options.carom=true&options.billiards=true">
	    Billiards
	  </a>
      </ul>
  </ul>

  <h1>Saved games</h1>
  
  <p>
    Follow <a href="/newgame?savegame=true">this</a> link to save the
    current game.  This will create a link that, when followed, will
    restore the game to its current state.  You can then either use it
    as is if you only want to keep the game for a little while or use
    the bookmark mechanism to permanently keep and organize your saved
    games.
  </p>

  <?lua
    local html = ""

    local function stringify (value)
       if type(value) == "string" then
	  return "\"" .. value .. "\""
       elseif type(value) == "table" then
	  for i, element in ipairs (value) do
	     value[i] = stringify(element) .. ","
	  end
	  
	  return "{" .. table.concat(value) .. "}"
       else
	  return tostring(value)
       end
    end

    if query and query.newgame then
       options.eightball = false
       options.nineball = false
       options.carom = false

       options.pool = false
       options.billiards = false

       for key, value in pairs (query) do
	  assert (loadstring(key .. "=" .. value))()
       end

       resources.dofile "scripts/rack.lua"
       resources.dofile "scripts/restart.lua"
    end

    if query and query.savegame then
       local link = "/newgame?restoregame=true&"

       for i, ball in ipairs (bodies.balls) do
	  billiards.opening[i] = ball.position
       end

       for _, value in pairs {"billiards.tablewidth", 
			      "billiards.tableheight", 
			      "billiards.cushionheight", 
			      "billiards.ballradius", 
			      "billiards.ballmass", 
			      "billiards.cuemass", 
			      "billiards.cueinertia", 
			      "billiards.cueforce", 
			      "billiards.cuelength", 
			      "billiards.staticfriction", 
			      "billiards.slidingfriction", 
			      "billiards.rollingfriction", 
			      "billiards.spinningfriction", 
			      "billiards.strikingfriction", 
			      "billiards.slowfriction", 
			      "billiards.fastfriction", 
			      "billiards.bouncingfriction", 
			      "billiards.collidingrestitution", 
			      "billiards.strikingrestitution", 
			      "billiards.bouncingrestitution", 
			      "billiards.jumpingrestitution",
			      "billiards.opening",
			      "options.pool",
			      "options.billiards",
			      "options.eightball",
			      "options.nineball",
			      "options.carom"} do
	  link = link .. value .. "=" ..
	         stringify (loadstring ("return " .. value)()) ..
	         "&"
       end
	   
       link = link .. "billiards.history={}" 

       html = html .. [[
     <p>
       Use <a href=]] .. link .. [[>this</a> link to restore the
       game you've just saved.  Bookmark it for safekeeping.
     </p>]]
     end

    if query and query.restoregame then
       for key, value in pairs (query) do
	  print (key .. "=" .. value)
	  assert (loadstring(key .. "=" .. value))()
       end
       
       resources.dofile "scripts/restart.lua"
    end

    return html
  ?>

  </table>
  <hr> 
  
</body>
