-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "accoustics"

function accoustics.sinewave (amplitude, frequency, samplerate, length)
   local samples = {}

   for i = 1, length do
      samples [i] = amplitude * math.sin (2 * math.pi * frequency *
					  i / samplerate)
   end

   return {
      samples = samples,
      frequency = samplerate,
      size = length
   }
end