/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include "target.h"

static int references[256];

@implementation Target

+(int) shootat: (int[2]) point
{
    int sample;
    
    glReadPixels (point[0], point[1],
		  1, 1,
		  GL_STENCIL_INDEX,
		  GL_UNSIGNED_INT,
		  &sample);

    return sample;
}

-(Target *) initWithReference: (int)ref
{
    int i;
    
    self = [super init];

    for (i = 1 ; i < 256 && references[i] != 0 ; i += 1);
    references[i] = ref;
    
    self->index = i;
    self->reference = ref;
    
    return self;
}

-(void) free
{
    references[self->index] = 0;

    [super free];
}

-(void) prepare: (lua_State *)L
{
    glEnable (GL_STENCIL_TEST);

    [super prepare: L];
}

-(void) traverse: (lua_State *)L
{
    glStencilFunc (GL_ALWAYS, self->index, 0xff);
    glStencilOp (GL_KEEP, GL_KEEP, GL_REPLACE);

    [super traverse: L];

    glStencilFunc (GL_ALWAYS, 0, 0xff);
}

-(void) cleanup: (lua_State *)L
{
    [super cleanup: L];

    glDisable (GL_STENCIL_TEST);
}

@end
