/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "system.h"
#include "body.h"

@implementation System

-(System *) init
{
    [super init];

    self->space = dSimpleSpaceCreate (NULL);
    dSpaceSetCleanup (self->space, 0);
    
    return self;
}

-(void) toggle: (lua_State *)L
{
    if (!linked) {
	dSpaceAdd([[self parent] space], (dGeomID)[self space]);
    } else {
	dSpaceRemove([[self parent] space], (dGeomID)[self space]);
    }

    [super toggle: L];
}

-(void) free
{
    dSpaceDestroy (self->space);

    [super free];
}
 
-(dSpaceID) space
{
    return self->space;
}
   
-(void) addBody: (id) node
{
    if ([node geom]) {
	dSpaceAdd ([self space], [node geom]);
    }
}

-(void) removeBody: (id) node
{
    if ([node geom]) {
	dSpaceRemove ([self space], [node geom]);
    }
}

@end
