/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <ctype.h>
#include <lua.h>
#include <lauxlib.h>
#include <AL/al.h>

#include "waveform.h"
#include "source.h"
#include "loop.h"

static char *decapitalize (char *s)
{
    s[0] = tolower(s[0]);

    return s;
}

static int node_tostring(lua_State *L)
{
    id N;

    N = *(id *)lua_touserdata(L, 1);
    lua_pushstring(L, [N name]);
   
    return 1;
}

static int node_index(lua_State *L)
{
    id N;

    N = *(id *)lua_touserdata(L, 1);
    
    [N get: L];
    
    return 1;
}

static int node_newindex(lua_State *L)
{
    id N;

    N = *(id *)lua_touserdata(L, 1);
    
    [N set: L];

    return 0;
}

static int node_gc(lua_State *L)
{
    id N;

    N = *(id *)lua_touserdata(L, 1);

    [N free];

    return 0;
}

static int waveform_len(lua_State *L)
{
    id T;

    T = *(id *)lua_touserdata(L, 1);

    lua_newtable(L);
    
    lua_pushnumber(L, [T length]);
    lua_rawseti(L, -2, 1);

    lua_pushnumber(L, [T frequency]);
    lua_rawseti(L, -2, 2);

    return 1;
}

int constructwaveform(lua_State *L)
{
    id T;
    ALshort *samples;
    int i, size, frequency;
    
    luaL_checktype(L, 1, LUA_TTABLE);

    lua_pushstring(L, "size");
    lua_gettable(L, 1);
    size = lua_tonumber(L, -1);
    lua_pop(L, 1);

    lua_pushstring(L, "frequency");
    lua_gettable(L, 1);
    frequency = lua_tonumber(L, -1);
    lua_pop(L, 1);

    lua_pushstring(L, "samples");
    lua_gettable(L, 1);
    
    samples = (ALshort *)malloc(size * sizeof(ALshort));

    for(i = 0 ; i < size ; i += 1) {
	lua_rawgeti(L, -1, i + 1);
	
	samples[i] = (ALshort)(32767 * lua_tonumber(L, -1));
	
	lua_pop(L, 1);
    }

    /* Create and initialize the waveform userdata. */

    T = [[Waveform alloc] initWithSamples: samples
	                           ofSize: size
	                      atFrequency: frequency];
    
    *(id *)lua_newuserdata(L, sizeof(id)) = T;

    lua_newtable(L);
    lua_pushstring(L, "__tostring");
    lua_pushcfunction(L, (lua_CFunction)node_tostring);
    lua_settable(L, -3);
    lua_pushstring(L, "__len");
    lua_pushcfunction(L, waveform_len);
    lua_settable(L, -3);
    lua_pushstring(L, "__gc");
    lua_pushcfunction(L, node_gc);
    lua_settable(L, -3);
    lua_setmetatable(L, -2);

    free (samples);
    
    return 1;
}

static int constructnode (lua_State *L)
{
    Class class;

    lua_pushvalue (L, lua_upvalueindex (1));
    class = (Class)lua_touserdata(L, -1);
    lua_pop(L, 1);

    /* Create the userdata... */
    
    *(id *)lua_newuserdata(L, sizeof(id)) = [[class alloc] init];
    
    lua_newtable (L);
    lua_pushstring(L, "__index");
    lua_pushcfunction(L, (lua_CFunction)node_index);
    lua_settable(L, -3);
    lua_pushstring(L, "__newindex");
    lua_pushcfunction(L, (lua_CFunction)node_newindex);
    lua_settable(L, -3);
    lua_pushstring(L, "__tostring");
    lua_pushcfunction(L, (lua_CFunction)node_tostring);
    lua_settable(L, -3);
    lua_pushstring(L, "__gc");
    lua_pushcfunction(L, (lua_CFunction)node_gc);
    lua_settable(L, -3);
    lua_setmetatable(L, -2);
    
    /* ...and initialize it. */

    if(lua_istable(L, 1)) {
	lua_pushnil(L);
	
	while(lua_next(L, 1)) {
	    lua_pushvalue(L, -2);
	    lua_insert(L, -2);
	    lua_settable(L, 2);
	}
    }

    return 1;
}

int luaopen_sound (lua_State *L)
{
    int i;

    Class nodes[] = {
	[Source class], [Loop class]
    };	

    lua_newtable (L);
    lua_pushcfunction (L, constructwaveform);
    lua_setfield(L, -2, "waveform");
    
    for (i = 0 ; i < sizeof(nodes) / sizeof(nodes[0]) ; i += 1) {
	lua_pushlightuserdata (L, nodes[i]);
	lua_pushcclosure (L, constructnode, 1);
	lua_setfield(L, -2, decapitalize(strdupa([nodes[i] name])));
    }

    lua_setglobal (L, lua_tostring (L, 1));

    return 0;
}
