/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <time.h>
#include "light.h"
#include "shadow.h"

@implementation Shadow

-(void)traverse: (lua_State *)L
{
    id parent, child;
		
    glMatrixMode(GL_MODELVIEW);

    for (parent = [self parent]; parent; parent = [parent parent]) {
	for (child = [parent children] ; child ; child = [child sister]) {
	    if ([child isMemberOf: [Light class]]) {
		GLfloat *r = [self translation];
		GLfloat *R = [self rotation];
		GLfloat *l = [child translation];
		GLfloat dot;

		dot = R[2] * (r[0] - l[0]) +
		      R[5] * (r[1] - l[1]) +
		      R[8] * (r[2] - l[2]);

		glPushMatrix();
		
		glLoadIdentity();
		glTranslatef (l[0], l[1], l[2]);
		glMultTransposeMatrixf ((GLfloat[16]){
			-dot, 0, 0, 0,
			0, -dot, 0, 0,
			0, 0, -dot, 0,
			-R[2], -R[5], -R[8], 0});
		glTranslatef (-l[0], -l[1], -l[2]);

		[super traverse: L];
		
		glPopMatrix();
	    }
	}
    }
}

@end

