/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <lua.h>
#include <lauxlib.h>
#include <ode/ode.h>
#include "polyhedron.h"

@implementation Polyhedron

-(Polyhedron *) init
{
    [super init];

    self->geom = dCreateTriMesh (NULL, self->data, NULL, NULL, NULL);
    dGeomSetBody ([self geom], [self body]);
  
    return self;
}

-(Polyhedron *) initWithVertices: (float *)floats
		      andIndices: (int *)ints
		          ofSize: (int[2]) n;
{
    [super init];

    /* Create the mesh data. */
    
    self->data = dGeomTriMeshDataCreate();
    self->vertices = (float *)malloc (3 * n[0] * sizeof(float));
    self->indices = (int *)malloc(n[1] * sizeof(int));

    memcpy (self->vertices, floats, 3 * n[0] * sizeof(float));
    memcpy (self->indices, ints, n[1] * sizeof(int));

    dGeomTriMeshDataBuildSingle (self->data,
				 self->vertices, 3 * sizeof(float), n[0],
				 self->indices, n[1], 3 * sizeof(int));
    
    self->size[0] = n[0];
    self->size[1] = n[1];
    
    return self;
}

-(void) freeData
{
    dGeomTriMeshDataDestroy (self->data);
    
    free (self->vertices);
    free (self->indices);
}

-(int) vertices
{
    return self->size[0];
}

-(int) indices
{
    return self->size[1];
}

-(dTriMeshDataID) data
{
    return self->data;
}

@end
