-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.


local function readfile (name)
   print ("  " .. name)
   return dofile(name)
end

local function scale(mesh)
   local n = mesh.size[1]
   local dx = 0.5 * (billiards.tablewidth - 2.84)
   local dy = 0.5 * (billiards.tableheight - 1.42)

   for i = 0, n - 1 do
      if mesh.vertices[8 * i + 1] > 1 then
	 mesh.vertices[8 * i + 1] = mesh.vertices[8 * i + 1] + dx
      elseif mesh.vertices[8 * i + 1] < -1 then
	 mesh.vertices[8 * i + 1] = mesh.vertices[8 * i + 1] - dx
      end

      if mesh.vertices[8 * i + 2] > 0.5 then
	 mesh.vertices[8 * i + 2] = mesh.vertices[8 * i + 2] + dy
      elseif mesh.vertices[8 * i + 2] < -0.5 then
	 mesh.vertices[8 * i + 2] = mesh.vertices[8 * i + 2] - dy
      end
   end

   return mesh
end

local function addcopy(from, to, deltax, deltay)
      local n = from.size[1]
      local m = from.size[2]
      local d = #to.vertices

      for j = 0, n - 1 do
	 table.insert(to.vertices, from.vertices[j * 8 + 1] + deltax)
	 table.insert(to.vertices, from.vertices[j * 8 + 2] + deltay)
	 table.insert(to.vertices, from.vertices[j * 8 + 3])

	 table.insert(to.vertices, from.vertices[j * 8 + 4])
	 table.insert(to.vertices, from.vertices[j * 8 + 5])
	 table.insert(to.vertices, from.vertices[j * 8 + 6])

	 table.insert(to.vertices, from.vertices[j * 8 + 7])
	 table.insert(to.vertices, from.vertices[j * 8 + 8])
      end

      for j = 1, m do
	 table.insert(to.indices, from.indices[j] + to.size[1])
      end

      to.size = {#to.vertices / 8, #to.indices}
   end

local function layout(mesh)
   local dx = 0.5 * billiards.tablewidth
   local dy = 0.5 * billiards.tableheight
   local new = {
      size = {0, 0},
      vertices = {},
      indices = {}
   }
   
   for i = -3, 3 do
      addcopy (mesh, new, i * dx / 4, -(dy + 0.1))
      addcopy (mesh, new, i * dx / 4, dy + 0.1)
   end
   
   for i = -1, 1 do
      addcopy (mesh, new, -(dx + 0.1), i * dy / 2)
      addcopy (mesh, new, dx + 0.1, i * dy / 2)
   end

   return new
end

imagery = {
   spot = textures.clamped(readfile "scripts/imagery/light/spot.lc"),
   tableambience = textures.clamped(readfile "scripts/imagery/light/tableambience.lc"),
   roomambience = textures.clamped(readfile "scripts/imagery/light/roomambience.lc"),
   cloth = textures.periodic(readfile "scripts/imagery/diffuse/beigecloth.lc"),
   cue = textures.clamped(readfile "scripts/imagery/diffuse/cue.lc"),

   table = {
      diffuse = textures.mirrored(readfile "scripts/imagery/diffuse/figured.lc"),
      specular = textures.mirrored(readfile "scripts/imagery/specular/figured.lc"),
   },
   
   parquet = {
      diffuse = textures.periodic(readfile "scripts/imagery/diffuse/parquet.lc"),
      specular = textures.periodic(readfile "scripts/imagery/specular/parquet.lc"),
   },
   
   checkers = textures.mirrored(textures.checkerboard (256, 256, 2)),
}

geometry = {
   table = meshes.static(scale(readfile "scripts/meshes/table.lc")),
   cloth = meshes.static(scale(readfile "scripts/meshes/cloth.lc")),
   diamonds = meshes.static(layout(readfile "scripts/meshes/diamonds.lc")),
   floor = meshes.static(readfile "scripts/meshes/floor.lc"),
   cue = meshes.static(readfile "scripts/meshes/cue.lc"),
   sphere = meshes.static (meshes.sphere (billiards.ballradius, 32, 16))
}

sounds = {
   sine = sound.waveform(sound.sinewave (1, 440, 44100, 44100)),
}

faces = {
   regular = widgets.face "Sans-20",
   small = widgets.face "Sans-16"
}
